package hdh

import (
	"context"
	"encoding/json"
)

//品牌
type BrandListReq struct {
	AppID string `json:"appId"`
	Page  int    `json:"page"`
	Limit int    `json:"limit"`
}

//品牌列表
type BrandListRes struct {
	Code string `json:"code"`
	Data struct {
		DataList []struct {
			ID        string `json:"id"`
			Name      string `json:"name"`                //品牌名称
			Desc      string `json:"desc,omitempty"`      //品牌描述
			LogoURL   string `json:"logoUrl,omitempty"`   //logo
			PosterURL string `json:"posterUrl,omitempty"` //海报
		} `json:"dataList"`
		NextPage  int `json:"nextPage"`
		Total     int `json:"total"`
		TotalPage int `json:"totalPage"`
	} `json:"data"`
	Message string `json:"message"`
	Success int    `json:"success"`
}

type BrandInfoReq struct {
	AppID string   `json:"appId"`
	Ids   []string `json:"ids"`
}

type BrandInfoRes struct {
	Code string `json:"code"`
	Data []struct {
		Desc      string `json:"desc,omitempty"`      //品牌描述
		ID        string `json:"id"`                  //
		LogoURL   string `json:"logoUrl,omitempty"`   //logo
		Name      string `json:"name"`                //品牌名称
		PosterURL string `json:"posterUrl,omitempty"` //海报
	} `json:"data"`
	Message string `json:"message"`
	Success int    `json:"success"`
}

//获取品牌列表
func GetBrandList(ctx context.Context, page, limit int) (res *BrandListRes, err error) {
	params := BrandListReq{
		AppID: "",
		Page:  page,
		Limit: limit,
	}
	result, err := post(ctx, "/brand/get_brand_list.do", params)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

//获取品牌
func GetBrandInfo(ctx context.Context, ids []string) (res *BrandInfoRes, err error) {
	params := BrandInfoReq{
		AppID: "",
		Ids:   ids,
	}
	result, err := post(ctx, "/brand/get_brands.do", params)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
