package gome

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type tokenGome struct {
}

var Token = tokenGome{}

type GetTokenReq struct {
	GrantType string `json:"grant_type"`
}

type TokenCommonRes struct {
	*CommonRes
	Data struct {
		AppKey           string `json:"appKey"`
		AccessToken      string `json:"access_token"`
		RefreshToken     string `json:"refresh_token"`
		ExpiresInSeconds int64  `json:"expiresInSeconds"`
		CreateTime       string `json:"createTime"`
	} `json:"data"`
}

type RefreshTokenReq struct {
	GrantType    string `json:"grant_type"`
	RefreshToken string `json:"refresh_token"`
}

func (tokenGome) Get(ctx context.Context) (res *TokenCommonRes, err error) {
	method := "token.create"
	req := &GetTokenReq{GrantType: "authorization_secret"}
	result, err := server.post(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

func (tokenGome) Refresh(ctx context.Context, refreshToken string) (res *TokenCommonRes, err error) {
	method := "token.refresh"
	req := &RefreshTokenReq{
		GrantType:    "authorization_code",
		RefreshToken: refreshToken,
	}
	result, err := server.post(ctx, method, req)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
