package upstream

import (
	"errors"
)

type CloudMsgType int

const (
	//产品下架
	CloudProductExpire CloudMsgType = 102
	// 产品新增或修改
	CloudProductModify CloudMsgType = 104
	// 产品上架
	CloudProductRepost CloudMsgType = 101
	// 商品池&超买价变更消息
	CloudProductPrice CloudMsgType = 103
	//发货
	CloudOrderSendGoods CloudMsgType = 201
	//确认收货
	CloudOrderReceive  CloudMsgType = 202
	// 售后同意
	CloudRefundAgree CloudMsgType = 301
	// 售后拒绝
	CloudRefundRefuse CloudMsgType = 302
	//售后成功
	CloudRefundSuccess CloudMsgType = 303
	//售后关闭
	CloudRefundClose CloudMsgType = 304
)

// ToType ToType
func (c CloudMsgType) ToType() (int, error) {
	switch c {
	case CloudProductExpire:
		return ProductExpire, nil
	case CloudProductModify:
		return ProductModify, nil
	case CloudProductRepost:
		return ProductRepost, nil
	case CloudProductPrice:
		return ProductPrice, nil
	case CloudOrderSendGoods:
		return OrderSendgoods, nil
	case CloudOrderReceive:
		return OrderComfirmReceiveGoods, nil
	case CloudRefundAgree:
		return RefundAgree, nil
	case CloudRefundRefuse:
		return RefundApply, nil
	case CloudRefundSuccess:
		return RefundSuccess, nil
	default:
		return 0, errors.New("not allow type")
	}
}
