package notify

type NotifyReqData struct {
	RealSource  int    `json:"real_source"`
	Source      int    `json:"source"`
	Type        int    `json:"type"`
	CreatedTime int    `json:"created_time"`
	Result      string `json:"result"`
}

type NotifyReq struct {
	Id   int           `json:"id"`
	Type string        `json:"type"`
	Data NotifyReqData `json:"data"`
}

//公共message消息
type NotifyServer struct {
	MsgType     int         `json:"msg_type"`
	MsgData     interface{} `json:"msg_data"`
	Source      int         `json:"source"`
	MsgSendTime int64       `json:"msg_send_time"`
}

//通知消息系统
type NotifyMessage struct {
	ID    int         `json:"id"`
	Type  interface{} `json:"type"`
	Data  interface{} `json:"data"`
	URL   string      `json:"url"`
	AppID int         `json:"appID"`
}

type GoodsMsgData struct {
	GoodsIDs []int `json:"goods_id"`
}

type OrderMsgData struct {
	OrderSn     string `json:"orderSn"`
	Sku         uint   `json:"sku"`
}

type RefundMsgData struct {
	AfterSaleID uint   `json:"afterSaleId"`
	OrderSn     string `json:"orderSn"`
	Sku         uint   `json:"sku"`
}

type TagsMsgData struct {
	Tags string `json:"tags"`
}
