package elastic

import "github.com/olivere/elastic/v7"

type BulkReq struct {
	Type string `json:"type"`
	IndexName string `json:"index_name"`
	DocId string `json:"doc_id"`
	RoutingId string `json:"routing_id"`
	Doc interface{} `json:"doc"`
}
type BulkIndex struct {
	*elastic.BulkIndexRequest
	*elastic.BulkDeleteRequest
	*elastic.BulkUpdateRequest
}
type UpdateByScriptReq struct {
	DocId string `json:"doc_id"`
	RoutingId string `json:"routing_id"`
	ScriptCtx string `json:"script_ctx"`
	IndexName string `json:"index_name"`
}
type GetDocReq struct {
	DocId string `json:"doc_id"`
	IndexName string `json:"index_name"`
}
type GetCountReq struct {
	Condition *elastic.BoolQuery
	IndexName string `json:"index_name"`
}
type GetListReq struct {
	Condition *elastic.BoolQuery
	Page int `json:"page"`
	Limit int `json:"limit"`
	SearchAfter *SearchAfter `json:"search_after"`
	IndexName string `json:"index_name"`
	
}
type SearchAfter struct {
	SortField struct{
		Field string `json:"field"`
		Sort  bool `json:"sort" `
	} `json:"sort_field"`
	Value int `json:"value"`
}
