package upstream

import (
	"github.com/gogf/gf/frame/g"
)

const (
	Jd    = 2
	Ali   = 6
	Tm    = 7
	Cloud = 1
	Sn    = 8
	Gome  = 10
)

var (
	//消息类型
	ProductExpire            = 101
	ProductModify            = 102
	ProductPrice             = 103
	ProductRepost            = 104
	OrderSendgoods           = 201
	OrderComfirmReceiveGoods = 202
	OrderSuccess             = 203
	OrderCancel              = 204
	RefundApply              = 300
	RefundAgree              = 301
	RefundRefuse             = 302
	RefundSuccess            = 303
)

func GetUpstreamList() (res interface{}, err error) {
	res = g.List{
		g.Map{
			"key":  Jd,
			"name": GetUpstreamName(Jd),
		},
		g.Map{
			"key":  Ali,
			"name": GetUpstreamName(Ali),
		},
		g.Map{
			"key":  Tm,
			"name": GetUpstreamName(Tm),
		},
		g.Map{
			"key":  Cloud,
			"name": GetUpstreamName(Cloud),
		},
		g.Map{
			"key":  Sn,
			"name": GetUpstreamName(Sn),
		},
		g.Map{
			"key":  Gome,
			"name": GetUpstreamName(Gome),
		},
	}
	return
}

func GetUpstreamName(source int) string {
	switch source {
	case Jd:
		return "京东"
	case Ali:
		return "阿里"
	case Tm:
		return "天猫"
	case Cloud:
		return "云仓"
	case Sn:
		return "苏宁"
	case Gome:
		return "国美"
	default:
		return "未知来源"
	}
}
