package jingdong

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type addressJD struct {
}

var Address = addressJD{}

type ParseRes struct {
	*CommonRes
	Result struct {
		NationId   string `json:"nationId"`   //国家ID
		Nation     string `json:"nation"`     //国家名称
		ProvinceId int    `json:"provinceId"` //一级地址ID
		Province   string `json:"province"`   //一级地址名称
		CityId     int    `json:"cityId"`     //二级地址ID
		City       string `json:"city"`       //二级地址名称
		CountyId   int    `json:"countyId"`   //三级地址ID
		County     string `json:"county"`     //三级地址名称
		TownId     int    `json:"townId"`     //四级地址ID
		Town       string `json:"town"`       //四级地址名称
	} `json:"result"`
}

type GetTownRes struct {
	*CommonRes
	Result map[string]int `json:"result"`
}

//Parse  地址详情转换京东地址编码
func (addressJD) Parse(ctx context.Context, address string) (res *ParseRes, err error) {
	method := "area/getJDAddressFromAddress"
	param := g.Map{
		"address": address,
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}

	err = gjson.New(result).Scan(&res)
	return
}

// CheckArea 验证地址有效性
func (addressJD) CheckArea(ctx context.Context, provinceId, cityId, countyId, townId interface{}) (res *CommonRes, err error) {
	method := "area/checkArea"
	param := g.Map{
		"provinceId": gconv.String(provinceId),
		"cityId":     gconv.String(cityId),
		"countyId":   gconv.String(countyId),
		"townId":     gconv.String(townId),
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}

	err = gjson.New(result).Scan(&res)
	return
}

// GetTown 查询四级地址
func (addressJD) GetTown(ctx context.Context, id interface{}) (res *GetTownRes, err error) {
	method := "area/getTown"
	param := g.Map{
		"id": gconv.String(id),
	}
	result, err := server.requestApi(ctx, method, param)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
