package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type refundWpc struct {
}

var Refund = refundWpc{}

type RefundReasonReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn    string `json:"orderSn"`
	ReturnId   string `json:"returnId,omitempty"`
	AreaId     string `json:"areaId,omitempty"`
}

type RefundReasonRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        struct{
		OrderId string `json:"order_id"`
		OrderSn string `json:"order_sn"`
		GoodsList []struct{
			GoodsId int `json:"goodsId"`
			Name string `json:"name"`
			ReturnAble bool `json:"returnAble"`
			ReasonList []struct{
				ReasonId int `json:"reasonId"`
				ReasonInfo string `json:"reasonInfo"`
				UploadImgFlag bool `json:"uploadImgFlag"`
			}
			Sizes []struct{
				SizeId int64 `json:"sizeId"`
				Name string `json:"name"`
				Price string `json:"price"`
				returnReasonId string `json:"returnReasonId"`
				returnReasonRemark string `json:"returnReasonRemark"`
				ReasonList []struct{
					ReasonId int `json:"reasonId"`
					ReasonInfo string `json:"reasonInfo"`
					UploadImgFlag bool `json:"uploadImgFlag"`
				}
				ImageList []string `json:"imageList"`
				ReturnPrimaryId string `json:"returnPrimaryId"`
				Num int `json:"num"`
			} `json:"sizes"`
		} `json:"goodsList"`
	} `json:"result"`
}



type RefundApplyReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn    string `json:"orderSn"`
	SizeInfo   map[string]uint `json:"sizeInfo"`
}

type RefundApplySizeInfo struct {
	SizeID   int `json:"sizeId"`
	Num      int `json:"num"`
	ReasonID int `json:"reasonId"`
}

type RefundApplyRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        struct{
		Success bool
	} `json:"result"`
}
type RefundSubmitReq struct {
	ChannelId    string `json:"vopChannelId"`
	UserNumber   string `json:"userNumber"`
	OrderSn      string `json:"orderSn"`
	CarriersCode string `json:"carriersCode"`
	TransportNo  string `json:"transportNo"`
	Remark       string `json:"remark,omitempty"`
	ReturnId     string `json:"returnId,omitempty"`
}

type RefundSubmitRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        struct{
		Success bool
	} `json:"result"`
}
type RefundDetailReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn    string `json:"orderSn"`
	ReturnId   string `json:"returnId"`
}

type RefundDetailRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        struct{
		OrderId string `json:"orderId"`
		OrderSn string `json:"orderSn"`
		ReturnId string `json:"returnId"`
		ReturnStatus string `json:"returnStatus"`
		TransportStatus string `json:"transportStatus"`
		ReturnProgressDesc string `json:"returnProgressDesc"`
		ReturnProgressTime string `json:"returnProgressTime"`
		ReturnAmount string `json:"returnAmount"`
		ReturnAddressInfo struct{
			Address string `json:"address"`
			Name string `json:"name"`
			Phone string `json:"phone"`
		} `json:"returnAddressInfo"`
		GoodsList struct{
			GoodsId string `json:"goodsId"`
			Name string `json:"name"`
			Image string `json:"image"`
			BrandCn string `json:"brandCn"`
			BrandEn string `json:"brandEn"`
			Sn string `json:"sn"`
			GoodsIdStr string `json:"goodsIdStr"`
			Sizes struct{
				SizeId int64 `json:"sizeId"`
				Name string `json:"name"`
				Price string `json:"price"`
				Color string `json:"color"`
				SizeIdStr string `json:"sizeIdStr"`
				ReturnReasonId string `json:"returnReasonId"`
				ReturnReasonRemark string `json:"returnReasonRemark"`
				ReasonList struct{
					ReasonId int `json:"reasonId"`
					ReasonInfo string `json:"reasonInfo"`
					UploadImgFlag bool `json:"uploadImgFlag"`

				}`json:"reasonList"`
				ImageList []string `json:"imageList"`
				ReturnPrimaryId string `json:"returnPrimaryId"`
				Num int `json:"num"`
			} `json:"sizes"`

		} `json:"goodsList"`
		ReturnGoodsAmount string `json:"returnGoodsAmount"`
		HasOXO string `json:"hasOXO"`
		IsStoreOrder string `json:"isStoreOrder"`
		ReturnStatusCode int  `json:"returnStatusCode"`//退货状态码: 1.未审核 2.退货已审核 3.审核不通过 4.退货返仓中 5.（已退款）已完成 6.已取消
		IsQualityProblem bool `json:"isQualityProblem"`
		CreateTime string `json:"createTime"`
		AuditTime string `json:"auditTime"`
		QualityProblemUserModifyTimeout string `json:"qualityProblemUserModifyTimeout"`
		CancelReasonType int  `json:"cancelReasonType"`
		CancelReason string `json:"cancelReason"`
		RefundStatus string `json:"refundStatus"` //退款状态, 0:未退款 1:已退款


	} `json:"result"`
}
type RefundCancelReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	OrderSn    string `json:"orderSn"`
	ReturnId   string `json:"returnId"`
}
type RefundCancelRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        struct{
		Success bool
	} `json:"result"`
}
//Reason 退货原因
func (refundWpc) Reason(ctx context.Context, req RefundReasonReq) (res *RefundReasonRes, err error) {
	method := "getReturnOrderCreate"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}
//Apply 申请
func (refundWpc) Apply(ctx context.Context, req RefundApplyReq) (res *RefundApplyRes, err error) {
	method := "orderReturnCreate"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}



//Submit 填写回寄物流单号
func (refundWpc) Submit(ctx context.Context, req RefundSubmitReq) (res *RefundSubmitRes, err error) {
	method := "updateReturnTransportNo"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}



//售后详情
func (refundWpc) Detail(ctx context.Context, req RefundDetailReq) (res *RefundDetailRes, err error) {
	method := "getOrderReturnDetail"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}
//取消售后
func (refundWpc) Cancel(ctx context.Context, req RefundCancelReq) (res *RefundCancelRes, err error) {
	method := "cancelReturnedOrder"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.NewWithOptions(result, gjson.Options{
		StrNumber: true,
	}).Scan(&res)
	return
}