package hdh

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/net/ghttp"
)

//物流轨迹回调接口
type ExpressNotifyRes struct {
	OrderNum string `json:"orderNum"` //订单号
	PkgList  []struct {
		ExpressCode int `json:"expressCode"` //物流状态code
		ExpressList []struct {
			ExpressCompany string `json:"expressCompany"` //物流公司
			ExpressDetail  []struct {
				Express string `json:"express"` //物流节点
				Time    string `json:"time"`    //时间
			} `json:"expressDetail"` //物流详情
			ExpressNum string `json:"expressNum"` //物流单号
		} `json:"expressList"` //物流轨迹信息
		OrderStatus     string `json:"orderStatus"`     //子订单状态
		OrderStatusCode int    `json:"orderStatusCode"` //订单状态code参考订单状态字典
		PkgNo           string `json:"pkgNo"`           //包裹号(一笔订单可能被拆分为多个包裹)
		Status          string `json:"status"`          //包裹物流轨迹状态 参考物流状态字典
	} `json:"pkgList"` //包裹信息
	UserOrderNum string `json:"userOrderNum"` //用户订单号
}

//物流信息查询请求
type ExpressQueryReq struct {
	AppID    string `json:"appId"`
	OrderNum string `json:"orderNum"`
}

//物流信息查询返回
type ExpressQueryRes struct {
	Code string `json:"code"`
	Data []struct {
		ExpressCode int `json:"expressCode"`
		ExpressList []struct {
			ExpressDetail []interface{} `json:"expressDetail"`
		} `json:"expressList"`
		ItemList []struct {
			ChannelName string `json:"channelName"`
			ChannelType string `json:"channelType"`
			ItemId      string `json:"itemId"`
			Number      int    `json:"number"`
			SkuId       string `json:"skuId"`
		} `json:"itemList"`
		OrderStatus     string `json:"orderStatus"`
		OrderStatusCode int    `json:"orderStatusCode"`
		PkgNo           string `json:"pkgNo"`
		Status          string `json:"status"`
	} `json:"data"`
	Message string `json:"message"`
	Success int    `json:"success"`
}

//物流信息查询
func ExpressQuery(ctx context.Context, req *ExpressQueryReq) (res *ExpressQueryRes, err error) {

	result, err := post(ctx, "/track/query_track.do", req)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

//物流信息回调
func ExpressNotify(r *ghttp.Request) (res *ExpressNotifyRes, err error) {
	body, err := CheckSign(r)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(body), &res)
	return
}
