package wangdian

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

var Goods = new(goods)

type goods struct {
}

type GoodsListReq struct {
	SpecNo    string `json:"spec_no"`
	GoodsNo   string `json:"goods_no"`
	BrandNo   string `json:"brand_no"`
	ClassName string `json:"class_name"`
	Barcode   string `json:"barcode"`
	StartTime string `json:"start_time"`
	EndTime   string `json:"end_time"`
	PageSize  string `json:"page_size"`
	PageNo    string `json:"page_no"`
}

type GoodsListRes struct {
	Code       int    `json:"code"`
	Message    string `json:"message"`
	TotalCount string `json:"total_count"`
	GoodsList  []struct {
		GoodsId       string      `json:"goods_id"`
		GoodsNo       string      `json:"goods_no"`
		GoodsName     string      `json:"goods_name"`
		ShortName     string      `json:"short_name"`
		Alias         string      `json:"alias"`
		GoodsType     string      `json:"goods_type"`
		SpecCount     string      `json:"spec_count"`
		Pinyin        string      `json:"pinyin"`
		BrandNo       string      `json:"brand_no"`
		BrandName     string      `json:"brand_name"`
		Remark        string      `json:"remark"`
		Prop1         string      `json:"prop1"`
		Prop2         string      `json:"prop2"`
		Prop3         string      `json:"prop3"`
		Prop4         string      `json:"prop4"`
		Prop5         string      `json:"prop5"`
		Prop6         string      `json:"prop6"`
		Origin        string      `json:"origin"`
		ClassName     string      `json:"class_name"`
		ClassId       string      `json:"class_id"`
		UnitName      interface{} `json:"unit_name"`
		AuxUnitName   interface{} `json:"aux_unit_name"`
		FlagName      interface{} `json:"flag_name"`
		GoodsCreated  string      `json:"goods_created"`
		GoodsModified string      `json:"goods_modified"`
		SpecList      []struct {
			SpecId           string      `json:"spec_id"`
			GoodsId          string      `json:"goods_id"`
			SpecNo           string      `json:"spec_no"`
			SpecCode         string      `json:"spec_code"`
			Barcode          string      `json:"barcode"`
			SpecName         string      `json:"spec_name"`
			LowestPrice      string      `json:"lowest_price"`
			RetailPrice      string      `json:"retail_price"`
			WholesalePrice   string      `json:"wholesale_price"`
			MemberPrice      string      `json:"member_price"`
			MarketPrice      string      `json:"market_price"`
			CustomPrice1     string      `json:"custom_price1"`
			CustomPrice2     string      `json:"custom_price2"`
			SaleScore        string      `json:"sale_score"`
			PackScore        string      `json:"pack_score"`
			PickScore        string      `json:"pick_score"`
			ValidityDays     string      `json:"validity_days"`
			SalesDays        string      `json:"sales_days"`
			ReceiveDays      string      `json:"receive_days"`
			Weight           string      `json:"weight"`
			Length           string      `json:"length"`
			Width            string      `json:"width"`
			Height           string      `json:"height"`
			IsSnEnable       string      `json:"is_sn_enable"`
			IsAllowNegStock  string      `json:"is_allow_neg_stock"`
			IsNotNeedExamine string      `json:"is_not_need_examine"`
			IsZeroCost       string      `json:"is_zero_cost"`
			IsLowerCost      string      `json:"is_lower_cost"`
			IsNotUseAir      string      `json:"is_not_use_air"`
			TaxRate          string      `json:"tax_rate"`
			LargeType        string      `json:"large_type"`
			Remark           string      `json:"remark"`
			SpecCreated      string      `json:"spec_created"`
			SpecModified     string      `json:"spec_modified"`
			Prop1            string      `json:"prop1"`
			Prop2            string      `json:"prop2"`
			Prop3            string      `json:"prop3"`
			Prop4            string      `json:"prop4"`
			Prop5            string      `json:"prop5"`
			Prop6            string      `json:"prop6"`
			ImgUrl           string      `json:"img_url"`
			SpecAuxUnitName  interface{} `json:"spec_aux_unit_name"`
			SpecUnitName     interface{} `json:"spec_unit_name"`
			PlatSpecCount    int         `json:"plat_spec_count"`
		} `json:"spec_list"`
	} `json:"goods_list"`
}

/**
  商品列表
*/
func (s *goods) List(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {

	result, err := post(ctx, "/openapi2/goods_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
