package ikucun

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type address struct {
}

var Address = address{}

type AddressProvinceRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Success bool   `json:"success"`
	Data    []struct {
		Id         string      `json:"id"`
		Name       string      `json:"name"`
		LevelType  int         `json:"levelType"`
		ParentId   interface{} `json:"parentId"`
		MergerName string      `json:"mergerName"`
	} `json:"data"`
}

func (s *address) Province(ctx context.Context) (res *AddressProvinceRes, err error) {
	method := "aikucun.base.address.province.list"
	result, err := get(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}

type AddressCityReq struct {
	ProvinceId string `json:"provinceId"`
}

type AddressCityRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Success bool   `json:"success"`
	Data    []struct {
		Id         string `json:"id"`
		Name       string `json:"name"`
		LevelType  int    `json:"levelType"`
		ParentId   string `json:"parentId"`
		MergerName string `json:"mergerName"`
	} `json:"data"`
}

func (s *address) City(ctx context.Context, req *AddressCityReq) (res *AddressCityRes, err error) {
	method := "aikucun.base.address.city.list"
	result, err := get(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type AddressAreaReq struct {
	CityId string `json:"cityId"`
}

type AddressAreaRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Success bool   `json:"success"`
	Data    []struct {
		Id         string `json:"id"`
		Name       string `json:"name"`
		LevelType  int    `json:"levelType"`
		ParentId   string `json:"parentId"`
		MergerName string `json:"mergerName"`
	} `json:"data"`
}

func (s *address) Area(ctx context.Context, req *AddressAreaReq) (res *AddressAreaRes, err error) {
	method := "aikucun.base.address.district.list"
	result, err := get(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}

type AddressStreetReq struct {
	DistrictId string `json:"districtId"`
}

type AddressStreetRes struct {
	Code    int    `json:"code"`
	Message string `json:"message"`
	Success bool   `json:"success"`
	Data    []struct {
		Id         string      `json:"id"`
		Name       string      `json:"name"`
		LevelType  int         `json:"levelType"`
		ParentId   string      `json:"parentId"`
		MergerName string      `json:"mergerName"`
		CityCode   string      `json:"cityCode"`
		ZipCode    string      `json:"zipCode"`
		Lng        interface{} `json:"lng"`
		Lat        interface{} `json:"lat"`
		Pinyin     string      `json:"pinyin"`
		ShortName  string      `json:"shortName"`
		DeleteFlag int         `json:"deleteFlag"`
		AreaId     interface{} `json:"areaId"`
		AreaName   interface{} `json:"areaName"`
	} `json:"data"`
}

func (s *address) Street(ctx context.Context, req *AddressStreetReq) (res *AddressStreetRes, err error) {
	method := "aikucun.base.address.villages.list"
	result, err := get(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
