package hcw

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type AddressParseReq struct {
	// 京东区域ID
	AreaID string `json:"area_id"`
	// 京东区域名称
	AreaName string `json:"area_name"`
	// 京东市区ID
	CityID string `json:"city_id"`
	// 京东市区名称
	CityName string `json:"city_name"`
	// 京东省份ID
	ProvinceID string `json:"province_id"`
	// 京东省份名称
	ProvinceName string `json:"province_name"`
	StreetID     string `json:"street_id"`
	StreetName   string `json:"street_name"`
	// 渠道来源（meide美的,aux奥克斯,myx美云销,mb美邦,hair海尔,skyworth创维,konka康佳）
	Source string `json:"source"`
}

type AddressParseRes struct {
	Id       int    `json:"id"`
	Code     string `json:"code"`
	Parent   string `json:"parent"`
	Source   string `json:"source"`
	Level    int    `json:"level"`
	Name     string `json:"name"`
	NameRaw  string `json:"name_raw"`
	FullPath string `json:"full_path"`
}

func (s *HcwClient) AddressParse(ctx context.Context, req *AddressParseReq) (res []*AddressParseRes, err error) {
	var method = "/address/match"
	result, err := s.post(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
