package dwd

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type logisticsDwd struct {
}

var Logistics = logisticsDwd{}

type LogisticsTraceReq struct {
	BatchNo    string `json:"batch_no,omitempty"`
	OutOrderId string `json:"out_order_id,omitempty"`
	OrderId    int    `json:"order_id"`
}
type LogisticsTraceRes struct {
	Errno     int                 `json:"errno"`
	Errmsg    string              `json:"errmsg"`
	Data      *LogisticsTraceData `json:"data"`
	RequestId string              `json:"request_id"`
	Timestamp int                 `json:"timestamp"`
	Signature string              `json:"signature"`
}

type LogisticsTraceData struct {
	LogisticsDetail struct {
		Contacter       string `json:"contacter"`
		Mobile          string `json:"mobile"`
		DeliveryComCode string `json:"delivery_com_code"`
		DeliveryComName string `json:"delivery_com_name"`
		Note            string `json:"note"`
		UpdatedAtFormat string `json:"updated_at_format"`
	} `json:"logisticsDetail"`
	TranceDetail struct {
		DeliveryNo      string `json:"delivery_no"`
		DeliveryComCode string `json:"delivery_com_code"`
		DeliveryComName string `json:"delivery_com_name"`
		Status          int    `json:"status"`
		StatusText      string `json:"status_text"`
		Msg             []struct {
			Time     string `json:"time"`
			Context  string `json:"context"`
			Ftime    string `json:"ftime,omitempty"`
			AreaName string `json:"areaName,omitempty"`
			Status   string `json:"status,omitempty"`
			Location string `json:"location,omitempty"`
		} `json:"msg"`
		ResetRecord []struct {
			OldDeliveryNo      string `json:"old_delivery_no"`
			OldDeliveryComCode string `json:"old_delivery_com_code"`
			OldDeliveryComName string `json:"old_delivery_com_name"`
			DeliveryNo         string `json:"delivery_no"`
			DeliveryComCode    string `json:"delivery_com_code"`
			DeliveryComName    string `json:"delivery_com_name"`
			CreatedAt          int    `json:"created_at"`
		} `json:"resetRecord"`
	} `json:"tranceDetail"`
	ReTranceDetail struct {
	} `json:"reTranceDetail"`
	DeliveryWay       int `json:"delivery_way"`
	SubDeliveryNoList []struct {
		DeliveryComCode string `json:"delivery_com_code"`
		DeliveryComName string `json:"delivery_com_name"`
		DeliveryNo      string `json:"delivery_no"`
	} `json:"sub_delivery_no_list"`
	SubDeliveryNo string `json:"sub_delivery_no"`
}

// Trace 物流轨迹
func (*logisticsDwd) Trace(ctx context.Context, req LogisticsTraceReq) (res *LogisticsTraceRes, err error) {
	method := "order.expressTrace"
	result, err := post(ctx, method, gconv.Map(req))
	if err != nil {
		return
	}
	res = &LogisticsTraceRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}
