package upstream

import (
	"github.com/gogf/gf/frame/g"
)

const (
	Cloud    = 1  //云仓
	Jd       = 2  //京东
	Ali      = 6  //阿里
	Tm       = 7  //天猫
	Sn       = 8  //苏宁
	Gome     = 10 //国美
	Schl     = 11 //盛创汇联
	Wpc      = 12 //唯品会
	Ikc      = 13 //爱库存
	Dwd      = 14 //好食期
	Itao     = 15 //淘特
	Hdh      = 16 //会订货
	TmNew    = 17 //天猫精选
	AliNew   = 18 //精选1688
	Yunzmall = 19
	Tmv3     = 20 //天猫优选
	Suning   = 21 //苏宁有货
)

var (
	//消息类型
	ProductExpire            = 101 //商品下架
	ProductModify            = 102 //商品变更
	ProductPrice             = 103 //商品价格
	ProductRepost            = 104 //商品上架
	ProductStock             = 104 //商品库存
	OrderSendgoods           = 201 //订单发货
	OrderComfirmReceiveGoods = 202 //确认收货
	OrderSuccess             = 203 //订单完成
	OrderCancel              = 204 //订单取消
	RefundApply              = 300
	RefundAgree              = 301
	RefundRefuse             = 302
	RefundSuccess            = 303
)

func GetUpstreamList() (res interface{}, err error) {
	res = g.List{
		g.Map{
			"key":  Jd,
			"name": GetUpstreamName(Jd),
		},
		g.Map{
			"key":  Ali,
			"name": GetUpstreamName(Ali),
		},
		g.Map{
			"key":  Tm,
			"name": GetUpstreamName(Tm),
		},
		g.Map{
			"key":  Cloud,
			"name": GetUpstreamName(Cloud),
		},
		g.Map{
			"key":  Sn,
			"name": GetUpstreamName(Sn),
		},
		g.Map{
			"key":  Gome,
			"name": GetUpstreamName(Gome),
		},
		g.Map{
			"key":  Schl,
			"name": GetUpstreamName(Schl),
		},
		g.Map{
			"key":  Wpc,
			"name": GetUpstreamName(Wpc),
		},
		g.Map{
			"key":  Ikc,
			"name": GetUpstreamName(Ikc),
		},
		g.Map{
			"key":  Dwd,
			"name": GetUpstreamName(Dwd),
		},
		g.Map{
			"key":  Itao,
			"name": GetUpstreamName(Itao),
		},
		g.Map{
			"key":  Hdh,
			"name": GetUpstreamName(Hdh),
		},
		g.Map{
			"key":  TmNew,
			"name": GetUpstreamName(TmNew),
		},
		g.Map{
			"key":  AliNew,
			"name": GetUpstreamName(AliNew),
		},
		g.Map{
			"key":  Yunzmall,
			"name": GetUpstreamName(Yunzmall),
		},
		g.Map{
			"key":  Tmv3,
			"name": GetUpstreamName(Tmv3),
		},
		g.Map{
			"key":  Suning,
			"name": GetUpstreamName(Suning),
		},
	}
	return
}

func GetUpstreamName(source int) string {
	switch source {
	case Jd:
		return "京东"
	case Ali:
		return "阿里"
	case Tm:
		return "天猫"
	case Cloud:
		return "生态云仓"
	case Sn:
		return "苏宁"
	case Gome:
		return "国美"
	case Schl:
		return "自营云仓"
	case Wpc:
		return "特卖一仓"
	case Ikc:
		return "特卖二仓"
	case Dwd:
		return "华东一仓"
	case Itao:
		return "淘宝"
	case Hdh:
		return "跨境一仓"
	case TmNew:
		return "天猫精选"
	case AliNew:
		return "厂家直供"
	case Yunzmall:
		return "云仓优选"
	case Tmv3:
		return "天猫优选"
	case Suning:
		return "苏宁有货"
	default:
		return "未知来源"
	}
}
