package tmv3

import (
	"context"
	"github.com/alibabacloud-go/linkedmall-20230930/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type GoodsSpuReq struct {
	DivisionCode string
	PurchaserId  string
	ProductIds   []string
}

type GoodsSpuRes struct {
	ProductSaleInfos []struct {
		CanSell       bool   `json:"canSell"`
		FuzzyQuantity string `json:"fuzzyQuantity"`
		LmItemId      string `json:"lmItemId"`
		ProductId     string `json:"productId"`
		ProductStatus string `json:"productStatus"`
		Quantity      int    `json:"quantity"`
		ShopId        string `json:"shopId"`
		Skus          []struct {
			CanSell       bool   `json:"canSell"`
			FuzzyQuantity string `json:"fuzzyQuantity"`
			MarkPrice     int    `json:"markPrice"`
			Price         int    `json:"price"`
			ProductId     string `json:"productId"`
			Quantity      int    `json:"quantity"`
			ShopId        string `json:"shopId"`
			SkuId         string `json:"skuId"`
			SkuStatus     string `json:"skuStatus"`
			Title         string `json:"title"`
		} `json:"skus"`
		Title string `json:"title"`
	} `json:"productSaleInfos"`
	RequestId string `json:"requestId"`
}

// Spu 批量查询选品池商品销售信息
func (s goodsTm) Spu(ctx context.Context, req GoodsSpuReq) (res *GoodsSpuRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "ListSelectionProductSaleInfos")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()
	if req.PurchaserId == "" {
		req.PurchaserId = PurchaserId
	}
	Request := &client.ListSelectionProductSaleInfosRequest{}
	var Body = new(client.ProductSaleInfoListQuery)
	Body.SetPurchaserId(req.PurchaserId)
	if req.DivisionCode != "" {
		Body.SetDivisionCode(req.DivisionCode)
	}
	var list []*string
	for _, item := range req.ProductIds {
		list = append(list, tea.String(item))
	}
	Body.SetProductIds(list)
	Request.SetBody(Body)

	r, err := server.ListSelectionProductSaleInfos(Request)
	if err != nil {
		return
	}
	//
	err = gjson.New(r.Body).Scan(&res)
	return
}
