package suning

import (
	"context"
	"encoding/json"
)

type OrderCreateReq struct {
	SnRequest struct {
		SnBody struct {
			AddOrder struct {
				Amount           string                      `json:"amount"`
				Address          string                      `json:"address"`
				TradeNo          string                      `json:"tradeNo"`
				ReceiverName     string                      `json:"receiverName"`
				Mobile           string                      `json:"mobile"`
				InvoiceState     string                      `json:"invoiceState"`
				Remark           string                      `json:"remark"`
				Telephone        string                      `json:"telephone"`
				CityId           string                      `json:"cityId"`
				TownId           string                      `json:"townId"`
				ChannelCode      string                      `json:"channelcode"`
				ProvinceId       string                      `json:"provinceId"`
				ServFee          string                      `json:"servFee"`
				CountyId         string                      `json:"countyId"`
				InvoiceType      string                      `json:"invoiceType"`
				HopeArrivalTime  string                      `json:"hopeArrivalTime"`
				Payment          string                      `json:"payment"`
				Sku              []*OrderCreateSku           `json:"sku"`
				SpecialVatTicket OrderCreateSpecialVatTicket `json:"specialVatTicket"`
				InvoiceTitle     string                      `json:"invoiceTitle"`
			} `json:"addOrder"`
		} `json:"sn_body"`
	} `json:"sn_reqest"`
}

type OrderCreateSku struct {
	UnitPrice    string `json:"unitPrice"`
	Num          string `json:"num"`
	SupplierCode string `json:"supplierCode"`
	SkuId        string `json:"skuId"`
}

type OrderCreateSpecialVatTicket struct {
	ConsigneeName      string `json:"consigneeName"`
	RegAccount         string `json:"regAccount"`
	RegTel             string `json:"regTel"`
	ConsigneeMobileNum string `json:"consigneeMobileNum"`
	RegAdd             string `json:"regAdd"`
	RegBank            string `json:"regBank"`
	TaxNo              string `json:"taxNo"`
	ConsigneeAddress   string `json:"consigneeAddress"`
}

type OrderCreateRes struct {
	SnResponseContent struct {
		SnBody struct {
			AddOrder struct {
				Amount string `json:"amount"`
				Skus   []struct {
					OrderItemId string `json:"orderItemId"`
					Price       string `json:"price"`
					Num         string `json:"num"`
					SkuId       string `json:"skuId"`
				} `json:"skus"`
				TradeNo string `json:"tradeNo"`
				OrderId string `json:"orderId"`
			} `json:"addOrder"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 创建订单
func OrderCreate(ctx context.Context, req *OrderCreateReq) (res OrderCreateRes, err error) {
	req.SnRequest.SnBody.AddOrder.ChannelCode = server.ChannelCode
	result, err := post(ctx, "suning.sngoods.order.add", req)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

type OrderConfirmReq struct {
	SnRequest struct {
		SnBody struct {
			ConfirmConfirmpaydt struct {
				OrderId string `json:"orderId"`
			} `json:"confirmConfirmpaydt"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderConfirmRes struct {
	SnResponseContent struct {
		SnBody struct {
			ConfirmConfirmpaydt struct {
				OrderId string `json:"orderId"`
			} `json:"confirmConfirmpaydt"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 代扣订单确认支付
func OrderConfirm(ctx context.Context, orderId string) (res OrderConfirmRes, err error) {
	params := OrderConfirmReq{}
	params.SnRequest.SnBody.ConfirmConfirmpaydt.OrderId = orderId
	result, err := post(ctx, "suning.sngoods.confirmpaydt.confirm", params)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

type OrderStatusReq struct {
	SnRequest struct {
		SnBody struct {
			GetOrderstatus struct {
				OrderId string `json:"orderId"`
			} `json:"getOrderstatus"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type OrderStatusRes struct {
	SnResponseContent struct {
		SnBody struct {
			GetOrderstatus struct {
				OrderId           string `json:"orderId"`
				OrderStatus       string `json:"orderStatus"`
				OrderItemInfoList []struct {
					OrderItemId string `json:"orderItemId"`
					StatusName  string `json:"statusName"`
					SkuId       string `json:"skuId"`
				} `json:"orderItemInfoList"`
			} `json:"getOrderstatus"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 获取订单状态
func GetOrderStatus(ctx context.Context, orderId string) (res OrderStatusRes, err error) {
	params := OrderStatusReq{}
	params.SnRequest.SnBody.GetOrderstatus.OrderId = orderId
	result, err := post(ctx, "suning.sngoods.orderstatus.get", params)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}
