package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type api struct {
}

var Api = api{}

/*
	获取分类
*/
func (api) Category(ctx context.Context) (res *CategoryRes, err error) {

	result, err := server.Post(ctx, "vip/api/goods/listGoodsCategory", g.Map{})
	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}
	return
}

/*
	获取商品
*/
func (api) GoodsList(ctx context.Context) (res *ListGoodsRes, err error) {

	result, err := server.Post(ctx, "vip/api/goods/listGoods", g.Map{})

	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}
	return
}

/*
	编码查询商品
*/
func (api) ListGoodsByCodes(ctx context.Context, codeList []string) (res *ListGoodsRes, err error) {

	data := g.Map{
		"codeList": gjson.New(codeList).MustToJsonString(),
	}
	result, err := server.Post(ctx, "vip/api/goods/listGoodsByCodes", data)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}
	return
}

/*
	订单运费预览
*/
func (api) OrderFreightPreview(ctx context.Context, req *OrderFreightPreviewReq) (res *OrderFreightPreviewRes, err error) {

	data := gconv.Map(req)
	result, err := server.Post(ctx, "vip/api/order/orderFreightPreview", data)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}
	return
}

/*
	同步订单快递单号
*/
func (api) SyncOrderExpNo(ctx context.Context, req string) (res *SyncOrderExpNoRes, err error) {

	result, err := server.Post(ctx, "vip/api/order/syncOrderExpNo", g.Map{"unionIdList": gjson.New([]string{req}).MustToJsonString()})
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}
	return
}

/*
	订单创建
*/
func (api) CreateOrder(ctx context.Context, req *CreateOrderReq) (res *CreateOrderRes, err error) {

	data := gconv.Map(req)

	result, err := server.Post(ctx, "vip/api/order/createOrder", data)
	if err != nil {
		return
	}

	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}
	if err != nil {
		return
	}
	return
}

/*
	查询订单快递/物流轨迹
*/
func (api) QueryExpTrack(ctx context.Context, req *QueryExpTrackReq) (res *QueryExpTrackRes, err error) {

	data := gconv.Map(req)

	result, err := server.Post(ctx, "vip/api/order/queryExpTrack", data)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)
	if err != nil {
		return
	}

	return
}
