package wangdian

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

var Order = new(order)

type order struct {
}

type OrderList struct {
	Oid           string  `json:"oid"`
	Status        int     `json:"status"`
	RefundStatus  int     `json:"refund_status"`
	GoodsId       string  `json:"goods_id"`
	SpecId        string  `json:"spec_id"`
	GoodsNo       string  `json:"goods_no"`
	SpecNo        string  `json:"spec_no"`
	GoodsName     string  `json:"goods_name"`
	SpecName      string  `json:"spec_name"`
	Num           int     `json:"num"`
	Price         float64 `json:"price"`
	AdjustAmount  float64 `json:"adjust_amount"`
	Discount      float64 `json:"discount"`
	ShareDiscount float64 `json:"share_discount"`
	Cid           string  `json:"cid"`
}

type TradeListReq struct {
	Tid              string       `json:"tid"`
	TradeStatus      int          `json:"trade_status"`
	DeliveryTerm     int          `json:"delivery_term"`
	PayStatus        int          `json:"pay_status"`
	TradeTime        string       `json:"trade_time"`
	PayTime          string       `json:"pay_time"`
	BuyerNick        string       `json:"buyer_nick"`
	BuyerEmail       string       `json:"buyer_email"`
	ReceiverMobile   string       `json:"receiver_mobile"`
	ReceiverTelno    string       `json:"receiver_telno"`
	ReceiverZip      string       `json:"receiver_zip"`
	ReceiverProvince string       `json:"receiver_province"`
	ReceiverName     string       `json:"receiver_name"`
	ReceiverCity     string       `json:"receiver_city"`
	ReceiverDistrict string       `json:"receiver_district"`
	ReceiverAddress  string       `json:"receiver_address"`
	LogisticsType    int          `json:"logistics_type"`
	InvoiceType      int          `json:"invoice_type"`
	InvoiceTitle     string       `json:"invoice_title"`
	InvoiceContent   string       `json:"invoice_content"`
	BuyerMessage     string       `json:"buyer_message"`
	CustData         string       `json:"cust_data"`
	Remark           string       `json:"remark"`
	RemarkFlag       int          `json:"remark_flag"`
	PostAmount       float64      `json:"post_amount"`
	OtherAmount      float64      `json:"other_amount"`
	Paid             float64      `json:"paid"`
	CodAmount        int          `json:"cod_amount"`
	ExtCodFee        int          `json:"ext_cod_fee"`
	OrderList        []*OrderList `json:"order_list"`
}

type TradePushReq struct {
	ShopNo    string `json:"shop_no"`
	Switch    int    `json:"switch"`
	TradeList string `json:"trade_list"`
}

type TradePushRes struct {
	Code     int    `json:"code"`
	Message  string `json:"message"`
	NewCount int    `json:"new_count"`
	ChgCount int    `json:"chg_count"`
}

/**
创建原始订单
*/
func (s *order) TradePush(ctx context.Context, req *TradePushReq) (res *TradePushRes, err error) {

	result, err := post(ctx, "/openapi2/trade_push.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type TradeQueryReq struct {
	StartTime string `json:"start_time"`
	EndTime   string `json:"end_time"`
	PageSize  string `json:"page_size"`
	PageNo    string `json:"page_no"`
	Status    string `json:"status"`
}

type TradeQueryRes struct {
	Code         int    `json:"code"`
	Message      string `json:"message"`
	TotalCount   int    `json:"total_count"`
	StockoutList []struct {
		StockoutId           string `json:"stockout_id"`
		OrderNo              string `json:"order_no"`
		SrcOrderNo           string `json:"src_order_no"`
		WarehouseNo          string `json:"warehouse_no"`
		ConsignTime          string `json:"consign_time"`
		Status               string `json:"status"`
		OrderType            string `json:"order_type"`
		GoodsCount           string `json:"goods_count"`
		GoodsTotalAmount     string `json:"goods_total_amount"`
		GoodsTotalCost       string `json:"goods_total_cost"`
		PostFee              string `json:"post_fee"`
		LogisticsNo          string `json:"logistics_no"`
		PackageFee           string `json:"package_fee"`
		Receivable           string `json:"receivable"`
		ReceiverName         string `json:"receiver_name"`
		ReceiverCountry      string `json:"receiver_country"`
		ReceiverProvince     string `json:"receiver_province"`
		ReceiverCity         string `json:"receiver_city"`
		ReceiverDistrict     string `json:"receiver_district"`
		ReceiverAddress      string `json:"receiver_address"`
		ReceiverMobile       string `json:"receiver_mobile"`
		ReceiverTelno        string `json:"receiver_telno"`
		ReceiverZip          string `json:"receiver_zip"`
		Remark               string `json:"remark"`
		Weight               string `json:"weight"`
		StockoutReason       string `json:"stockout_reason"`
		Subtype              string `json:"subtype"`
		OuterNo              string `json:"outer_no"`
		OperatorName         string `json:"operator_name"`
		LogisticsType        string `json:"logistics_type"`
		LogisticsCode        string `json:"logistics_code"`
		LogisticsName        string `json:"logistics_name"`
		BadReason            string `json:"bad_reason"`
		ReceiverDtb          string `json:"receiver_dtb"`
		PrintRemark          string `json:"print_remark"`
		Paid                 string `json:"paid"`
		RefundStatus         string `json:"refund_status"`
		TradeType            string `json:"trade_type"`
		SalesmanNo           string `json:"salesman_no"`
		Fullname             string `json:"fullname"`
		SalesmanName         string `json:"salesman_name"`
		TradeStatus          string `json:"trade_status"`
		WarehouseName        string `json:"warehouse_name"`
		BlockReason          string `json:"block_reason"`
		PrintBatchNo         string `json:"print_batch_no"`
		TradeNo              string `json:"trade_no"`
		SrcTradeNo           string `json:"src_trade_no"`
		NickName             string `json:"nick_name"`
		CustomerNo           string `json:"customer_no"`
		CustomerName         string `json:"customer_name"`
		TradeTime            string `json:"trade_time"`
		PayTime              string `json:"pay_time"`
		FlagName             string `json:"flag_name"`
		PostAmount           string `json:"post_amount"`
		IdCardType           string `json:"id_card_type"`
		IdCard               string `json:"id_card"`
		ReceiverArea         string `json:"receiver_area"`
		ShopName             string `json:"shop_name"`
		ShopNo               string `json:"shop_no"`
		ShopRemark           string `json:"shop_remark"`
		Modified             string `json:"modified"`
		BuyerMessage         string `json:"buyer_message"`
		CsRemark             string `json:"cs_remark"`
		InvoiceType          string `json:"invoice_type"`
		InvoiceTitle         string `json:"invoice_title"`
		InvoiceContent       string `json:"invoice_content"`
		InvoiceId            string `json:"invoice_id"`
		CodAmount            string `json:"cod_amount"`
		DeliveryTerm         string `json:"delivery_term"`
		FenxiaoType          string `json:"fenxiao_type"`
		FenxiaoNick          string `json:"fenxiao_nick"`
		PlatformId           string `json:"platform_id"`
		TradeId              string `json:"trade_id"`
		EmployeeNo           string `json:"employee_no"`
		CheckerName          string `json:"checker_name"`
		Discount             string `json:"discount"`
		SrcTids              string `json:"src_tids"`
		Tax                  string `json:"tax"`
		TaxRate              string `json:"tax_rate"`
		Currency             string `json:"currency"`
		Created              string `json:"created"`
		StockCheckTime       string `json:"stock_check_time"`
		PackagerNo           string `json:"packager_no"`
		PackagerName         string `json:"packager_name"`
		PickerNo             string `json:"picker_no"`
		PickerName           string `json:"picker_name"`
		PrinterNo            string `json:"printer_no"`
		PrinterName          string `json:"printer_name"`
		ExaminerNo           string `json:"examiner_no"`
		ExaminerName         string `json:"examiner_name"`
		OrderTypeName        string `json:"order_type_name"`
		ReceiverProvinceCode string `json:"receiver_province_code"`
		ReceiverCityCode     string `json:"receiver_city_code"`
		ReceiverDistrictCode string `json:"receiver_district_code"`
		DetailsList          []struct {
			RecId        string      `json:"rec_id"`
			StockoutId   string      `json:"stockout_id"`
			SpecNo       string      `json:"spec_no"`
			GoodsCount   string      `json:"goods_count"`
			TotalAmount  string      `json:"total_amount"`
			Paid         string      `json:"paid"`
			SellPrice    string      `json:"sell_price"`
			Remark       string      `json:"remark"`
			GoodsName    string      `json:"goods_name"`
			GoodsNo      string      `json:"goods_no"`
			BrandNo      string      `json:"brand_no"`
			BrandName    string      `json:"brand_name"`
			SpecName     string      `json:"spec_name"`
			SpecCode     string      `json:"spec_code"`
			CostPrice    string      `json:"cost_price"`
			Weight       string      `json:"weight"`
			GoodsId      string      `json:"goods_id"`
			SpecId       string      `json:"spec_id"`
			Prop1        string      `json:"prop1"`
			Prop2        string      `json:"prop2"`
			Prop3        string      `json:"prop3"`
			Prop4        string      `json:"prop4"`
			Prop5        string      `json:"prop5"`
			Prop6        string      `json:"prop6"`
			PlatformId   string      `json:"platform_id"`
			RefundStatus string      `json:"refund_status"`
			MarketPrice  string      `json:"market_price"`
			Discount     string      `json:"discount"`
			ShareAmount  string      `json:"share_amount"`
			TaxRate      string      `json:"tax_rate"`
			Barcode      string      `json:"barcode"`
			UnitName     interface{} `json:"unit_name"`
			SaleOrderId  string      `json:"sale_order_id"`
			SharePost    string      `json:"share_post"`
			GiftType     string      `json:"gift_type"`
			SrcOid       string      `json:"src_oid"`
			SrcTid       string      `json:"src_tid"`
			FromMask     string      `json:"from_mask"`
			GoodsType    string      `json:"goods_type"`
			BatchNo      string      `json:"batch_no"`
			SuiteNo      string      `json:"suite_no"`
			GoodProp1    string      `json:"good_prop1"`
			GoodProp2    string      `json:"good_prop2"`
			GoodProp3    string      `json:"good_prop3"`
			GoodProp4    string      `json:"good_prop4"`
			GoodProp5    string      `json:"good_prop5"`
			GoodProp6    string      `json:"good_prop6"`
		} `json:"details_list"`
	} `json:"stockout_list"`
}

/**
查询销售出库单
*/
func (s *order) TradeQuery(ctx context.Context, req *TradeQueryReq) (res *TradeQueryRes, err error) {

	result, err := post(ctx, "/openapi2/purchase_order_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type SalesTradeQueryReq struct {
	Status    string `json:"status"`
	StartTime string `json:"start_time"`
	EndTime   string `json:"end_time"`
	PageSize  int    `json:"page_size"`
	PageNo    int    `json:"page_no"`
	//ShopNo         string `json:"shop_no"`
	//WarehouseNo    string `json:"warehouse_no"`
	//Goodstax       int    `json:"goodstax"`
	//HasLogisticsNo int    `json:"has_logistics_no"`
	//IsFuzzy        int    `json:"is_fuzzy"`
	//Src            int    `json:"src"`
	//ShopNos        string `json:"shop_nos"`
	SrcTid string `json:"src_tid"`
}

type SalesTradeQueryRes struct {
	Code       int    `json:"code"`
	Message    string `json:"message"`
	TotalCount int    `json:"total_count"`
	Trades     []struct {
		TradeId           string `json:"trade_id"`
		TradeNo           string `json:"trade_no"`
		PlatformId        string `json:"platform_id"`
		WarehouseType     string `json:"warehouse_type"`
		SrcTids           string `json:"src_tids"`
		PayAccount        string `json:"pay_account"`
		TradeStatus       string `json:"trade_status"`
		ConsignStatus     string `json:"consign_status"`
		TradeType         string `json:"trade_type"`
		DeliveryTerm      string `json:"delivery_term"`
		FreezeReason      string `json:"freeze_reason"`
		RefundStatus      string `json:"refund_status"`
		FenxiaoType       string `json:"fenxiao_type"`
		FenxiaoNick       string `json:"fenxiao_nick"`
		TradeTime         string `json:"trade_time"`
		PayTime           string `json:"pay_time"`
		BuyerNick         string `json:"buyer_nick"`
		ReceiverName      string `json:"receiver_name"`
		ReceiverProvince  string `json:"receiver_province"`
		ReceiverCity      string `json:"receiver_city"`
		ReceiverDistrict  string `json:"receiver_district"`
		ReceiverAddress   string `json:"receiver_address"`
		ReceiverMobile    string `json:"receiver_mobile"`
		ReceiverTelno     string `json:"receiver_telno"`
		ReceiverZip       string `json:"receiver_zip"`
		ReceiverArea      string `json:"receiver_area"`
		ReceiverRing      string `json:"receiver_ring"`
		ReceiverDtb       string `json:"receiver_dtb"`
		ToDeliverTime     string `json:"to_deliver_time"`
		BadReason         string `json:"bad_reason"`
		LogisticsNo       string `json:"logistics_no"`
		BuyerMessage      string `json:"buyer_message"`
		CsRemark          string `json:"cs_remark"`
		RemarkFlag        string `json:"remark_flag"`
		PrintRemark       string `json:"print_remark"`
		GoodsTypeCount    string `json:"goods_type_count"`
		GoodsCount        string `json:"goods_count"`
		GoodsAmount       string `json:"goods_amount"`
		PostAmount        string `json:"post_amount"`
		OtherAmount       string `json:"other_amount"`
		Discount          string `json:"discount"`
		Receivable        string `json:"receivable"`
		DapAmount         string `json:"dap_amount"`
		CodAmount         string `json:"cod_amount"`
		ExtCodFee         string `json:"ext_cod_fee"`
		GoodsCost         string `json:"goods_cost"`
		PostCost          string `json:"post_cost"`
		Paid              string `json:"paid"`
		Weight            string `json:"weight"`
		Profit            string `json:"profit"`
		Tax               string `json:"tax"`
		TaxRate           string `json:"tax_rate"`
		Commission        string `json:"commission"`
		InvoiceType       string `json:"invoice_type"`
		InvoiceTitle      string `json:"invoice_title"`
		InvoiceContent    string `json:"invoice_content"`
		SalesmanId        string `json:"salesman_id"`
		CheckerId         string `json:"checker_id"`
		FcheckerId        string `json:"fchecker_id"`
		CheckouterId      string `json:"checkouter_id"`
		StockoutNo        string `json:"stockout_no"`
		FlagName          string `json:"flag_name"`
		TradeFrom         string `json:"trade_from"`
		SingleSpecNo      string `json:"single_spec_no"`
		RawGoodsCount     string `json:"raw_goods_count"`
		RawGoodsTypeCount string `json:"raw_goods_type_count"`
		Currency          string `json:"currency"`
		SplitPackageNum   string `json:"split_package_num"`
		InvoiceId         string `json:"invoice_id"`
		VersionId         string `json:"version_id"`
		Modified          string `json:"modified"`
		Created           string `json:"created"`
		IdCardType        string `json:"id_card_type"`
		IdCard            string `json:"id_card"`
		ShopNo            string `json:"shop_no"`
		ShopName          string `json:"shop_name"`
		ShopRemark        string `json:"shop_remark"`
		WarehouseNo       string `json:"warehouse_no"`
		CustomerName      string `json:"customer_name"`
		CustomerNo        string `json:"customer_no"`
		LogisticsId       string `json:"logistics_id"`
		LogisticsName     string `json:"logistics_name"`
		LogisticsCode     string `json:"logistics_code"`
		LogisticsType     string `json:"logistics_type"`
		Fullname          string `json:"fullname"`
		CheckerName       string `json:"checker_name"`
		GoodsList         []struct {
			RecId           string `json:"rec_id"`
			TradeId         string `json:"trade_id"`
			SpecId          string `json:"spec_id"`
			PlatformId      string `json:"platform_id"`
			SrcOid          string `json:"src_oid"`
			SuiteId         string `json:"suite_id"`
			SrcTid          string `json:"src_tid"`
			GiftType        string `json:"gift_type"`
			RefundStatus    string `json:"refund_status"`
			GuaranteeMode   string `json:"guarantee_mode"`
			DeliveryTerm    string `json:"delivery_term"`
			BindOid         string `json:"bind_oid"`
			Num             string `json:"num"`
			Price           string `json:"price"`
			ActualNum       string `json:"actual_num"`
			RefundNum       string `json:"refund_num"`
			OrderPrice      string `json:"order_price"`
			SharePrice      string `json:"share_price"`
			Adjust          string `json:"adjust"`
			Discount        string `json:"discount"`
			ShareAmount     string `json:"share_amount"`
			SharePost       string `json:"share_post"`
			Paid            string `json:"paid"`
			GoodsName       string `json:"goods_name"`
			GoodsId         string `json:"goods_id"`
			GoodsNo         string `json:"goods_no"`
			SpecName        string `json:"spec_name"`
			SpecNo          string `json:"spec_no"`
			SpecCode        string `json:"spec_code"`
			SuiteNo         string `json:"suite_no"`
			Flag            string `json:"flag"`
			SuiteName       string `json:"suite_name"`
			SuiteNum        string `json:"suite_num"`
			SuiteAmount     string `json:"suite_amount"`
			SuiteDiscount   string `json:"suite_discount"`
			ApiGoodsName    string `json:"api_goods_name"`
			ApiSpecName     string `json:"api_spec_name"`
			Weight          string `json:"weight"`
			Commission      string `json:"commission"`
			GoodsType       string `json:"goods_type"`
			LargeType       string `json:"large_type"`
			InvoiceType     string `json:"invoice_type"`
			InvoiceContent  string `json:"invoice_content"`
			FromMask        string `json:"from_mask"`
			Cid             string `json:"cid"`
			Remark          string `json:"remark"`
			Modified        string `json:"modified"`
			Created         string `json:"created"`
			PlatformGoodsId string `json:"platform_goods_id"`
			PlatformSpecId  string `json:"platform_spec_id"`
			Prop2           string `json:"prop2"`
			TaxRate         string `json:"tax_rate"`
		} `json:"goods_list"`
	} `json:"trades"`
}

/**
查询订单管理
*/
func (s *order) SalesTradeQuery(ctx context.Context, req *SalesTradeQueryReq) (res *SalesTradeQueryRes, err error) {

	result, err := post(ctx, "/openapi2/sales_trade_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type SalesApiTradeQueryReq struct {
	Tid        string `json:"tid"`
	PlatformId int    `json:"platform_id"`
	ShopNo     string `json:"shop_no"`
	StartTime  string `json:"start_time"`
	EndTime    string `json:"end_time"`
	PageNo     int    `json:"page_no"`
	PageSize   int    `json:"page_size"`
}

type SalesApiTradeQueryRes struct {
	Code       int    `json:"code"`
	Message    string `json:"message"`
	TotalCount string `json:"total_count"`
	TradeList  []struct {
		PlatformId     string `json:"platform_id"`
		ShopNo         string `json:"shop_no"`
		Tid            string `json:"tid"`
		ProcessStatus  string `json:"process_status"`
		TradeStatus    string `json:"trade_status"`
		GuaranteeMode  string `json:"guarantee_mode"`
		PayStatus      string `json:"pay_status"`
		DeliveryTerm   string `json:"delivery_term"`
		PayMethod      string `json:"pay_method"`
		RefundStatus   string `json:"refund_status"`
		TradeTime      string `json:"trade_time"`
		PayTime        string `json:"pay_time"`
		BuyerMessage   string `json:"buyer_message"`
		Remark         string `json:"remark"`
		ToDeliverTime  string `json:"to_deliver_time"`
		Receivable     string `json:"receivable"`
		GoodsAmount    string `json:"goods_amount"`
		PostAmount     string `json:"post_amount"`
		OtherAmount    string `json:"other_amount"`
		Discount       string `json:"discount"`
		Paid           string `json:"paid"`
		PlatformCost   string `json:"platform_cost"`
		Received       string `json:"received"`
		DapAmount      string `json:"dap_amount"`
		CodAmount      string `json:"cod_amount"`
		PiAmount       string `json:"pi_amount"`
		RefundAmount   string `json:"refund_amount"`
		LogisticsType  string `json:"logistics_type"`
		InvoiceType    string `json:"invoice_type"`
		InvoiceTitle   string `json:"invoice_title"`
		InvoiceContent string `json:"invoice_content"`
		TradeFrom      string `json:"trade_from"`
		FenxiaoType    string `json:"fenxiao_type"`
		EndTime        string `json:"end_time"`
		Modified       string `json:"modified"`
		Created        string `json:"created"`
		Currency       string `json:"currency"`
		Score          string `json:"score"`
		GoodsList      []struct {
			PlatformId     string `json:"platform_id"`
			Tid            string `json:"tid"`
			Oid            string `json:"oid"`
			Status         string `json:"status"`
			ProcessStatus  string `json:"process_status"`
			RefundStatus   string `json:"refund_status"`
			OrderType      string `json:"order_type"`
			InvoiceType    string `json:"invoice_type"`
			InvoiceContent string `json:"invoice_content"`
			BindOid        string `json:"bind_oid"`
			GoodsId        string `json:"goods_id"`
			SpecId         string `json:"spec_id"`
			GoodsNo        string `json:"goods_no"`
			SpecNo         string `json:"spec_no"`
			GoodsName      string `json:"goods_name"`
			SpecName       string `json:"spec_name"`
			RefundId       string `json:"refund_id"`
			Num            string `json:"num"`
			Price          string `json:"price"`
			AdjustAmount   string `json:"adjust_amount"`
			Discount       string `json:"discount"`
			ShareDiscount  string `json:"share_discount"`
			TotalAmount    string `json:"total_amount"`
			ShareAmount    string `json:"share_amount"`
			SharePost      string `json:"share_post"`
			Paid           string `json:"paid"`
			RefundAmount   string `json:"refund_amount"`
			Modified       string `json:"modified"`
			Created        string `json:"created"`
			EndTime        string `json:"end_time"`
			Remark         string `json:"remark"`
		} `json:"goods_list"`
		DiscountList []interface{} `json:"discount_list"`
	} `json:"trade_list"`
}

/**
查询原始订单
*/
func (s *order) SalesApiTradeQuery(ctx context.Context, req *SalesApiTradeQueryReq) (res *SalesApiTradeQueryRes, err error) {

	result, err := post(ctx, "/openapi2/sales_api_trade_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type LogisticsMultiQueryReq struct {
	StartModified string `json:"start_modified"`
	EndModified   string `json:"end_modified"`
	PageSize      int    `json:"page_size"`
	PageNo        int    `json:"page_no"`
	LogisticsNo   string `json:"logistics_no"`
	TradeNo       string `json:"trade_no"`
}
type LogisticsMultiQueryRes struct {
	Code               int    `json:"code"`
	Message            string `json:"message"`
	LogisticsMultiList []struct {
		RecId       string `json:"rec_id"`
		OperatorId  string `json:"operator_id"`
		TradeId     string `json:"trade_id"`
		LogisticsNo string `json:"logistics_no"`
		LogisticsId string `json:"logistics_id"`
		PostCost    string `json:"post_cost"`
		PrintStatus string `json:"print_status"`
		Weight      string `json:"weight"`
		Modified    string `json:"modified"`
		Created     string `json:"created"`
		GoodsInfo   []struct {
			SpecNo string `json:"spec_no"`
			Num    string `json:"num"`
		} `json:"goods_info"`
	} `json:"logistics_multi_list"`
}

/**
查询多物流单号
*/
func (s *order) LogisticsMultiQuery(ctx context.Context, req *LogisticsMultiQueryReq) (res *LogisticsMultiQueryRes, err error) {

	result, err := post(ctx, "/openapi2/logistics_multi_query.php", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
