package tmv3

import (
	"context"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/os/gtime"
)

type RefundDetailRes struct {
	ApplyDisputeDesc string `json:"applyDisputeDesc"`
	ApplyReason      struct {
		ReasonTextId int    `json:"reasonTextId"`
		ReasonTips   string `json:"reasonTips"`
	} `json:"applyReason"`
	BizClaimType                 int    `json:"bizClaimType"`
	DisputeCreateTime            string `json:"disputeCreateTime"`
	DisputeDesc                  string `json:"disputeDesc"`
	DisputeEndTime               string `json:"disputeEndTime"`
	DisputeId                    string `json:"disputeId"`     //逆向单 ID
	DisputeStatus                int    `json:"disputeStatus"` //逆向的状态 1-退货待处理 2-待买家退货 3-待商家收货 4-退款关闭 5-退款成功 6-已拒绝退款 17-取消退款中
	DisputeType                  int    `json:"disputeType"`
	OrderId                      string `json:"orderId"`
	OrderLogisticsStatus         int    `json:"orderLogisticsStatus"` //订单物流状态 1-未发货 -> 等待卖家发货 2-已发货 -> 等待买家确认收货 3-已收货 -> 交易成功 6-部分发货中 8-还未创建物流订单
	RefundFee                    int    `json:"refundFee"`            //退费金额
	RefunderAddress              string `json:"refunderAddress"`      //商家退货地址（disputeStatus=2，待买家退货状态时可获取退货地址，如需保存退货地址请在此状态时保存）
	RefunderName                 string `json:"refunderName"`         //退货收货人
	RefunderTel                  string `json:"refunderTel"`
	RefunderZipCode              string `json:"refunderZipCode"` //退货地址邮编
	ReturnGoodCount              int    `json:"returnGoodCount"`
	ReturnGoodLogisticsStatus    int    `json:"returnGoodLogisticsStatus"` //退货物流状态 0-未退货 1-等待揽收 2-快件已揽收 3-物流走件中 4-派送中 5-已签收 6-签收失败
	SellerAgreeMsg               string `json:"sellerAgreeMsg"`
	SellerRefuseAgreementMessage string `json:"sellerRefuseAgreementMessage"` //卖家拒绝的留言说明
	SellerRefuseReason           string `json:"sellerRefuseReason"`
	OrderLineId                  string `json:"orderLineId"`
}

// Detail 获取售后单详情
func (s refundTm) Detail(ctx context.Context, req RefundCommonReq) (res *RefundDetailRes, err error) {
	Start := gtime.TimestampMilli()
	ctx = context.WithValue(ctx, "URI", "GetRefundOrder")
	defer func() {
		Log(ctx, req, res, err, Start)
	}()

	r, err := server.GetRefundOrder(tea.String(req.DisputeId))
	if err != nil {
		return
	}

	err = gjson.New(r.Body).Scan(&res)
	return
}
