package ikucun

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type activityIkc struct {
}

//Activity 活动
var Activity = activityIkc{}

type ActivityListReq struct {
	PageIndex string `json:"pageIndex"`
	PageSize  string `json:"pageSize"`
}

type ActivityListRes struct {
	Code    string `json:"code"`
	Success bool   `json:"success"`
	Message string `json:"message"`
	Data    struct {
		ActivityList []struct {
			ActivityId   string `json:"activityId"`
			StartTime    string `json:"startTime"`
			EndTime      string `json:"endTime"`
			ActiveType   int    `json:"activeType"`
			UpDownStatus int    `json:"upDownStatus"`
		} `json:"activityList"`
	} `json:"data"`
}

//List 列表
func (*activityIkc) List(ctx context.Context, req *ActivityListReq) (res *ActivityListRes, err error) {
	method := "mengxiang.supply.consignment.activity.search"
	result, err := post(ctx, method, req)
	_ = gjson.New(result).Scan(&res)
	return
}
