package hcw

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type RefundCreateReq struct {
	RefundOrderNo         string   `json:"refund_order_no"`
	OrderSn               string   `json:"order_sn"`
	RefundType            int      `json:"refund_type"`
	RefundReason          string   `json:"refund_reason"`
	RefundReasonType      int      `json:"refund_reason_type"`
	RefundRemark          string   `json:"refund_remark"`
	RefundAddressMerchant string   `json:"refund_address_merchant"`
	RefundVoucher         []string `json:"refund_voucher"`
	RefundPrice           int      `json:"refund_price"`
	RefundGoods           struct {
		OrderGoodsCode string `json:"order_goods_code"`
		RefundGoodsNum int    `json:"refund_goods_num"`
	} `json:"refund_goods"`
}

type RefundCreateRes struct {
}

func (s *HcwClient) OrderRefundCreate(ctx context.Context, req *RefundCreateReq) (res *RefundCreateRes, err error) {
	var method = "/api/v1/orderRefund"
	result, err := s.post(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

type RefundDetailReq struct {
	OrderSn       string `json:"order_sn"`
	RefundOrderNo string `json:"refund_order_no"`
}

type RefundDetailRes struct {
}

func (s *HcwClient) OrderRefundDetail(ctx context.Context, req *RefundDetailReq) (res *RefundDetailRes, err error) {
	var method = "/api/v1/orderRefund"
	result, err := s.get(ctx, method, req)
	if nil != err {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}
