package hcw

import (
	"encoding/json"
	"errors"
	"github.com/gogf/gf/net/ghttp"
	"github.com/gogf/gf/util/gconv"
)

//notify_id	string	唯一请求ID（用于幂等校验）示例：20240320140000_123456
//app_id	string	平台分配的应用ID
//type	string	业务类型标识，见下表
//data	object	业务数据对象
//signature	string	请求签名（验证方法见第四章）

type OrderNotifyRes struct {
	NotifyId  string          `json:"notify_id"`
	AppId     string          `json:"app_id"`
	Type      string          `json:"type"`
	Data      OrderNotifyData `json:"data"`
	Signature string          `json:"signature"`
}

// order_shipped	订单发货	{ "order_no":"P123"}
// refund_result	发起售后成功	{ "order_no":100.00}
// product_status	产品状态变更(1上架2下架)	{ "product_no":"SKU123"}
type OrderNotifyData struct {
	OrderNo   string `json:"order_no"`
	ProductNo string `json:"product_no"`
	RefundNo  string `json:"refund_no"`
	Type      string `json:"type"`
	Source    string `json:"source"`
}

// 回调
func (s *HcwClient) CallBack(r *ghttp.Request) (res *OrderNotifyRes, err error) {
	body := r.GetBodyString()
	if body == "" {
		return
	}
	err = json.Unmarshal([]byte(body), &res)
	if nil != err {
		return
	}
	err = s.CheckSign(res)

	return
}

func (s *HcwClient) CheckSign(req *OrderNotifyRes) (err error) {
	reqMap := gconv.Map(req.Data)
	signature, err := s.EncryptWithSignature(reqMap)
	if req.Signature != signature {
		err = errors.New("incorrect signature")
	}

	return
}
