package aliNew

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type OrderBeforeRes struct {
	Success             bool              `json:"success"`
	ErrorCode           string            `json:"errorCode"`
	ErrorMsg            string            `json:"errorMsg"`
	OrderPreviewResuslt []OrderBeforeItem `json:"orderPreviewResuslt"`
}

type OrderBeforeItem struct {
	SumPayment           int64      `json:"sumPayment"`           //订单总费用, 单位为分
	SumPaymentNoCarriage int64      `json:"sumPaymentNoCarriage"` //不包含运费的货品总费用, 单位为分.
	SumCarriage          int64      `json:"sumCarriage"`          //总运费信息, 单位为分.
	Status               bool       `json:"status"`               //
	ShopPromotionList    []struct { //可用店铺级别优惠列表
		PromotionId int64 `json:"promotionId"` //优惠券ID
	} `json:"shopPromotionList"` //规格信息
	Message   string `json:"message"` //返回信息
	CargoList []struct {
		FinalUnitPrice float64 `json:"finalUnitPrice"` //最终单价
		SpecId         string  `json:"specId"`         //规格ID，offer内唯一
		OfferId        string  `json:"offerId"`        //商品ID
		SkuId          int64   `json:"skuId"`          //规格ID
	} `json:"cargoList"` //规格信息
}

// Before 验证订单商品
func (s *orderAli) Before(ctx context.Context, req *OrderCommonReq) (res *OrderBeforeRes, err error) {
	method := "com.alibaba.trade/alibaba.createOrder.preview"

	result, err := server.Post(ctx, method, g.Map{
		"access_token":   server.AccessToken,
		"addressParam":   gjson.New(req.AddressParam).MustToJsonString(),
		"cargoParamList": gjson.New(req.CargoParam).MustToJsonString(),
		"flow":           "ttpft",
	})
	_ = gjson.New(result).Scan(&res)
	return
}
