package notify

//推送到消息系统的公共消息
type NotifyServer struct {
	MsgType     int         `json:"msg_type"`
	MsgData     interface{} `json:"msg_data"`
	Source      int         `json:"source"`
	MsgSendTime int64       `json:"msg_send_time"`
}

//推送到消息系统的售后消息
type NotifyRefundData struct {
	AfsServiceId interface{} `json:"afs_service_id"` //三方服务单号
}

//推送到消息系统的订单消息
type NotifyOrderData struct {
	ThirdChildOrderSn string `json:"third_child_order_sn"` //三方子订单号
	ThirdOrderSn      string `json:"third_order_sn"`       //三方订单号
	OrderSn           string `json:"order_sn"`             //供应链订单号
}

//推送到消息系统的商品消息
type NotifyGoodsData struct {
	ThirdGoodsInfo []ThirdGoods `json:"third_goods"` //三方商品信息
}

type ThirdGoods struct {
	ThirdId interface{} `json:"third_id"`       //三方商品id
	Skus    []int       `json:"skus,omitempty"` //三方规格id
}

//通知消息系统
type NotifyMessage struct {
	ID       interface{} `json:"id"`
	Type     interface{} `json:"type"`
	Data     interface{} `json:"data"`
	URL      string      `json:"url"`
	AppID    int         `json:"app_id"`
	PushTime int         `json:"push_time"`
	Times    int         `json:"times"`
}

//通知客户商品/选品消息
type GoodsMsgData struct {
	GoodsIDs []int `json:"goodsIds"`
}

//通知客户订单消息
type OrderMsgData struct {
	OrderSn      string `json:"orderSn,omitempty"` //外部订单号
	Sku          uint   `json:"sku,omitempty"`
	OrderGoodsSn string `json:"orderGoodsSn,omitempty"` //商品订单号
	Sn           string `json:"sn,omitempty"`           //店铺订单号
}

//通知客户售后消息
type RefundMsgData struct {
	AfterSaleID uint   `json:"afterSaleId"` //退款服务ID
	RefundSn    string `json:"refund_sn"`   //退款单号
	OrderSn     string `json:"orderSn"`
	Sku         uint   `json:"sku"`
}

//通知客户标签消息
type TagsMsgData struct {
	Tags string `json:"tags"`
}

//通知api请求日志
type NotifyApiLog struct {
	ID           interface{} `json:"id"`
	Type         interface{} `json:"type"`        //api类型 goods/order
	Method       interface{} `json:"method"`      //请求方式
	RequestUri   interface{} `json:"request_uri"` //请求路径
	AppID        interface{} `json:"app_id"`
	RequestTime  interface{} `json:"request_time"`  //请求时间戳
	Body         interface{} `json:"body"`          //请求参数
	ResponseTime interface{} `json:"response_time"` //响应时间
	ResponseBody interface{} `json:"response_body"` //响应参数
	Error        interface{} `json:"error"`         //错误信息
}

//内部推送商品更新消息
type NotifyGoodsUpdateServer struct {
	Type        int         `json:"type"`
	MsgData     []GoodsData `json:"msg_data"`
	MsgSendTime int64       `json:"msg_send_time"`
}
type GoodsData struct {
	GoodsId  int64 `json:"goods_id"`
	RealSale int64 `json:"real_sale"`
}
