package tm

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/util/gconv"
)

type goodsTm struct {
}

var Goods = goodsTm{}

type GoodsInventoryReq struct {
	ItemId    string   `json:"ItemId"`
	SkuIdList []string `json:"SkuIdList"`
}

type GoodsInventoryRes struct {
	Code      string `json:"Code"`
	Success   bool   `json:"Success"`
	Message   string `json:"Message"`
	RequestId string `json:"RequestId"`
	ItemList  struct {
		Item []struct {
			ItemId  int `json:"ItemId"`
			SkuList struct {
				Sku []struct {
					SkuId     int `json:"SkuId"`
					Inventory struct {
						Quantity int `json:"Quantity"`
					} `json:"Inventory"`
				} `json:"Sku"`
			} `json:"SkuList"`
		} `json:"Item"`
	} `json:"ItemList"`
}

//Inventory 查询库存
func (s *goodsTm) Inventory(ctx context.Context, DivisionCode string, req []GoodsInventoryReq) (res *GoodsInventoryRes, err error) {
	method := "queryItemInventory"
	request := convert("ItemList", gconv.Maps(req))
	request["DivisionCode"] = DivisionCode
	result, err := post(ctx, method, request)

	_ = json.Unmarshal([]byte(result), &res)
	return
}
