package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type logisticsItao struct {
}

var Logistics = logisticsItao{}

type LogisticsTraceRes struct {
	Result struct {
		Result []struct {
			DetailList []struct {
				Action       string `json:"action"`
				GmtCreate    string `json:"gmtCreate"`
				StanderdDesc string `json:"standerdDesc"`
				Status       string `json:"status"`
				Time         string `json:"time"`
				MailNo       string `json:"mailNo,omitempty"`
				TpName       string `json:"tpName,omitempty"`
			} `json:"detailList"`
			GoodsList []interface{} `json:"goodsList"`
			MailNo    string        `json:"mailNo"`
			Receiver  struct {
				Adr          string `json:"adr"`
				CityName     string `json:"cityName"`
				DistrictName string `json:"districtName"`
				Name         string `json:"name"`
				ProvinceName string `json:"provinceName"`
				Telphone     string `json:"telphone"`
			} `json:"receiver"`
			Status struct {
				StatusCode string `json:"statusCode"`
				StatusDesc string `json:"statusDesc"`
			} `json:"status"`
		} `json:"result"`
		Success bool   `json:"success"`
		ErrMsg  string `json:"errMsg"`
		ErrCode string `json:"errCode"`
	} `json:"result"`
}

//Trace 物流轨迹
func (logisticsItao) Trace(ctx context.Context, req string) (res *LogisticsTraceRes, err error) {
	method := "com.alibaba.c2m/ltao.logistics.queryDetail"

	result, err := server.Post(ctx, method, g.Map{
		"request": g.Map{
			"tradeId": req,
		},
	})
	_ = gjson.New(result).Scan(&res)
	return
}
