package tm

import (
	"context"
	"encoding/json"
	link "github.com/alibabacloud-go/linkedmall-20220531/v2/client"
	"github.com/alibabacloud-go/tea/tea"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type refundTm struct {
}

var Refund = refundTm{}

type RefundSubmitReq struct {
	UserId       string
	SubLmOrderId string //子订单号
	DisputeId    string //售后ID
	CpCode       string //物流编码
	LogisticsNo  string //物流单号
}
type RefundCancelRes struct {
	Code    string `json:" Code"`
	Message string `json:"Message"`
	RequestId string `json:"RequestId"`
	Success   bool   `json:"Success"`
	Model struct{
		SubDistributionOrderId string `json:"SubDistributionOrderId"`
		DisputeStatus          int    `json:"DisputeStatus"`
		DisputeType            int    `json:"DisputeType"`
	} `json:"Model"`

}
type CommonRes struct {
	Code    string `json:" Code"`
	Message string `json:"Message"`
	RequestId string `json:"RequestId"`
	Success   bool   `json:"Success"`
}


type RefundBeforeReq struct {
	SubDistributionOrderId string `json:"SubDistributionOrderId"`
	BizClaimType int32 `json:"BizClaimType"`
	GoodsStatus  string `json:"GoodsStatus"`
}

type RefundBeforeRes struct {
	Code                string `json:"Code"`
	Message             string `json:"Message"`
	RequestId           string `json:"RequestId"`
	Model struct {
		SubDistributionOrderId string `json:"SubDistributionOrderId"`
		BizClaimType           int    `json:"BizClaimType"`
		MainOrderRefund        bool   `json:"MainOrderRefund"`
		MaxRefundFeeData       struct {
			MaxRefundFee int `json:"MaxRefundFee"`
			MinRefundFee int `json:"MinRefundFee"`
		} `json:"MaxRefundFeeData"`
		RefundReasonList []struct {
			ReasonTextId       string `json:"ReasonTextId"`
			ReasonTips         string `json:"ReasonTips"`
			ProofRequired      bool   `json:"ProofRequired"`
			RefundDescRequired bool   `json:"RefundDescRequired"`
		} `json:"RefundReasonList"`
     }
}
type RefundApplyReq struct {
	UserId            string
	SubLmOrderId      string                //子订单号
	BizClaimType      string                //退款类型
	ApplyRefundFee    int64                //申请退款金额
	ApplyRefundCount  int32                //退货数量
	ApplyReasonTextId int64                //退款原因ID
	LeaveMessage      string                //留言
	LeavePictureList  []*RefundApplyPicture //凭证，某些原因要求必须有凭证。
	GoodsStatus       int32                //当退款类型:仅退款时，货物状态:为4未 发货。所有状态:4: 未发货, 6: 已发货, 1: 未收到货, 2: 已收到货, 3:已寄回, 5: 卖家确 认收货
}

type RefundApplyPicture struct {
	Picture string `json:"Picture"` //图片地址
	Desc    string `json:"Desc"`    //图片描述
}

type RefundApplyRes struct {
	Code                  string `json:"Code"`
	Message               string `json:"Message"`
	RequestId             string `json:"RequestId"`
	Model struct {
		SubDistributionOrderId  string `json:"SubDistributionOrderId"`  //当前发起逆向的子订单号
		DisputeStatus int    `json:"DisputeStatus"` //逆向的状态
		DisputeType   int    `json:"DisputeType"`   //任意退款类型
		DisputeId     int64  `json:"DisputeId"`     //shou

	} `json:"Model"`
}
//Before 前置
func (s *refundTm) Before(ctx context.Context, req *RefundBeforeReq) (res *RefundBeforeRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}

	result ,err :=client.InitApplyRefund4Distribution(&link.InitApplyRefund4DistributionRequest{
		BizClaimType:       tea.Int32(req.BizClaimType),
		DistributorId: tea.String(server.DistributorId),
		SubDistributionOrderId: tea.String(req.SubDistributionOrderId),
		TenantId:      tea.String(server.TenantId),
		GoodsStatus: tea.Int32(gconv.Int32(req.GoodsStatus)),
	})
	if err!=nil{
		return
	}

	if result==nil{
		return
	}
	err =gjson.New(result.Body).Scan(&res)

	return
}



//Apply 申请
func (s *refundTm) Apply(ctx context.Context, req *RefundApplyReq) (res *RefundApplyRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}
	result ,err :=client.ApplyRefund4Distribution(&link.ApplyRefund4DistributionRequest{
		ApplyReasonTextId:      tea.Int64(req.ApplyReasonTextId),
		ApplyRefundCount:       tea.Int32(req.ApplyRefundCount),
		ApplyRefundFee:         tea.Int64(req.ApplyRefundFee),
		BizClaimType:           tea.Int32(req.ApplyRefundCount),
		DistributorId:          tea.String(server.DistributorId),
		GoodsStatus:            tea.Int32(req.GoodsStatus),
		//LeaveMessage:           tea.String("测试退款"),
		LeavePictureLists:     nil,
		SubDistributionOrderId:  tea.String(req.SubLmOrderId),
		TenantId:               tea.String(server.TenantId),
	})
	if err!=nil{
		return
	}

	if result==nil{
		return
	}
	err =gjson.New(result.Body).Scan(&res)

	return
}

type RefundInfoRes struct {
	Code                    string `json:"Code"`
	Message                 string `json:"Message"`
	RequestId               string `json:"RequestId"`
	Model struct{
		DistributionOrderId       string `json:"DistributionOrderId"`
		SubDistributionOrderId    string `json:"SubDistributionOrderId"`
		BizClaimType              int    `json:"BizClaimType"`
		OrderLogisticsStatus      int    `json:"OrderLogisticsStatus"`
		DisputeStatus             int    `json:"DisputeStatus"`
		ReturnGoodLogisticsStatus int    `json:"ReturnGoodLogisticsStatus"`
		DisputeType               int    `json:"DisputeType"`
		RefundFeeData             struct {
			MaxRefundFee int `json:"MaxRefundFee"`
			MinRefundFee int `json:"MinRefundFee"`
		} `json:"RefundFeeData"`
		SellerRefuseReason           string `json:"SellerRefuseReason"`
		RefundFee                    int    `json:"RefundFee"`
		RealRefundFee                int    `json:"RealRefundFee"`
		DisputeDesc                  string `json:"DisputeDesc"`
		SellerAgreeMsg               string `json:"SellerAgreeMsg"`
		SellerRefuseAgreementMessage string `json:"SellerRefuseAgreementMessage"`
		ApplyReason                  struct {
			ReasonTextId int    `json:"ReasonTextId"`
			ReasonTips   string `json:"ReasonTips"`
		} `json:"ApplyReason"`
		ApplyDisputeDesc  string `json:"ApplyDisputeDesc"`
		DisputeCreateTime string `json:"DisputeCreateTime"`
		DisputeEndTime    string `json:"DisputeEndTime"`
		DisputeId         int    `json:"DisputeId"`
		RefunderAddress   string `json:"RefunderAddress"`
		RefunderName      string `json:"RefunderName"`
		RefunderTel       string `json:"RefunderTel"`
		RefunderZipCode   string `json:"RefunderZipCode"`
	} `json:"Model"`
}
//Submit 提交退货物流信息接口
func (s *refundTm) Submit(ctx context.Context, req RefundSubmitReq) (res *CommonRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}

	result ,err :=client.SubmitReturnGoodLogistics4Distribution(&link.SubmitReturnGoodLogistics4DistributionRequest{
		DisputeId:       tea.Int64(gconv.Int64(req.DisputeId)),
		DistributorId: tea.String(server.DistributorId),
		SubDistributionOrderId: tea.String(req.SubLmOrderId),
		TenantId:      tea.String(server.TenantId),
		LogisticsNo: tea.String(req.LogisticsNo),
		CpCode: tea.String(req.CpCode),
	})
	if err!=nil{
		return
	}

	if result==nil{
		return
	}
	err =gjson.New(result.Body).Scan(&res)

	return
}

//Cancel 取消退款申请接口
func (s *refundTm) Cancel(ctx context.Context, UserId, subLmOrderId, disputeId string) (res *RefundCancelRes, err error) {
	client,err :=initClient()
	if err!=nil{
		return
	}
	if client==nil{
		return
	}

	result ,err :=client.CancelRefund4Distribution(&link.CancelRefund4DistributionRequest{
		DisputeId:       tea.Int64(gconv.Int64(disputeId)),
		DistributorId: tea.String(server.DistributorId),
		SubDistributionOrderId: tea.String(subLmOrderId),
		TenantId:      tea.String(server.TenantId),
	})
	if err!=nil{
		return
	}

	if result==nil{
		return
	}
	err =gjson.New(result.Body).Scan(&res)

	return
}
//Info 详情
func (s *refundTm) Detail(ctx context.Context,subOrderId string) (res *RefundInfoRes, err error) {
	client,err :=initClient()
	if err!=nil{
	return
	}
	if client==nil{
	return
	}
	result ,err :=client.QueryRefundApplicationDetail4Distribution(&link.QueryRefundApplicationDetail4DistributionRequest{
	DistributorId: tea.String(server.DistributorId),
	SubDistributionOrderId: tea.String(subOrderId),
	TenantId:      tea.String(server.TenantId),
	})
	if err!=nil{
		return
	}

	if result==nil{
	return
	}
	a,_ :=json.Marshal(result.Body)
	if err := json.Unmarshal([]byte(a), &res); err != nil {
		panic(err)
	}
	return
}
