package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type goodsItao struct {
}

var Goods = goodsItao{}

type GoodsDetailRes struct {
	Result struct {
		Result struct {
			DebugInfoMap struct {
				TraceId string `json:"traceId"`
			} `json:"debugInfoMap"`
			EnterNewLink string `json:"enterNewLink"`
			Item         struct {
				CategoryId   []string `json:"categoryId"`
				CategoryName []string `json:"categoryName"`
				City         string   `json:"city"`
				FastPostFee  int      `json:"fastPostFee"`
				Images       []string `json:"images"`
				ItemId       string   `json:"itemId"`
				ItemServices []struct {
					Desc        string `json:"desc"`
					Title       string `json:"title"`
					VideoUrl    string `json:"videoUrl,omitempty"`
					ActionTitle string `json:"actionTitle,omitempty"`
					ActionUrl   string `json:"actionUrl,omitempty"`
				} `json:"itemServices"`
				MainPic         string `json:"mainPic"`
				OrdinaryPostFee int    `json:"ordinaryPostFee"`
				Props           []struct {
					Content string `json:"content"`
					Word    string `json:"word"`
				} `json:"props"`
				Prov         string `json:"prov"`
				Receipt      bool   `json:"receipt"`
				SoldQuantity int    `json:"soldQuantity"`
				Status       int    `json:"status"`
				Title        string `json:"title"`
			} `json:"item"`
			Seller struct {
				ShopName string `json:"shopName"`
			} `json:"seller"`
			SkuBase struct {
				Props []interface{} `json:"props"`
				Skus  []interface{} `json:"skus"`
			} `json:"skuBase"`
			SkuCore struct {
				DefaultSkuId int                  `json:"defaultSkuId"`
				Sku2Info     map[string]GoodsItem `json:"sku2info"`
			} `json:"skuCore"`
		} `json:"result"`
	} `json:"result"`
}

//Detail 详情[实时]
func (goodsItao) Detail(ctx context.Context, GoodsID string) (res *GoodsDetailRes, err error) {
	method := "com.alibaba.c2m/ltao.detail.jnpiter.getDetail"

	result, err := server.Post(ctx, method, g.Map{
		"parameters": g.Map{
			"itemIds": GoodsID,
		},
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDynamicRes struct {
	Result struct {
		Data []struct {
			DebugInfoMap struct {
				TraceId string `json:"traceId"`
			} `json:"debugInfoMap"`
			EnterNewLink string               `json:"enterNewLink"`
			Sku2Info     map[string]GoodsItem `json:"sku2info"`
		} `json:"data"`
		ItemIds string `json:"itemIds"`
		Time    int    `json:"time"`
	} `json:"result"`
}

type GoodsItem struct {
	QuantityVague  string `json:"quantityVague"`
	OriginalPrice  string `json:"originalPrice"`
	TjbMarketPrice string `json:"tjbMarketPrice"`
}

//Dynamic 详情[动态]
func (goodsItao) Dynamic(ctx context.Context, GoodsID string) (res *GoodsDynamicRes, err error) {
	method := "com.alibaba.c2m/ltao.detail.csp.getDetailDynamic"

	result, err := server.Post(ctx, method, g.Map{
		"parameters": g.Map{
			"itemIds": GoodsID,
		},
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodBatchRes struct {
	Result struct {
		Data []struct {
			DebugInfoMap struct {
				TraceId string `json:"traceId"`
			} `json:"debugInfoMap"`
			EnterNewLink string `json:"enterNewLink"`
			Item         struct {
				CategoryId   []string `json:"categoryId"`
				CategoryName []string `json:"categoryName"`
				City         string   `json:"city"`
				FastPostFee  int      `json:"fastPostFee"`
				Images       []string `json:"images"`
				ItemId       string   `json:"itemId"`
				ItemServices []struct {
					Desc        string `json:"desc"`
					Title       string `json:"title"`
					VideoUrl    string `json:"videoUrl,omitempty"`
					ActionTitle string `json:"actionTitle,omitempty"`
					ActionUrl   string `json:"actionUrl,omitempty"`
				} `json:"itemServices"`
				MainPic         string `json:"mainPic"`
				OrdinaryPostFee int    `json:"ordinaryPostFee"`
				Props           []struct {
					Content string `json:"content"`
					Word    string `json:"word"`
				} `json:"props"`
				Prov         string `json:"prov"`
				Receipt      bool   `json:"receipt"`
				SoldQuantity int    `json:"soldQuantity"`
				Status       int    `json:"status"`
				Title        string `json:"title"`
			} `json:"item"`
			Seller struct {
				ShopName string `json:"shopName"`
			} `json:"seller"`
			Sku2Info map[string]GoodsItem `json:"sku2info"`
			SkuBase  struct {
				Props []interface{} `json:"props"`
				Skus  []interface{} `json:"skus"`
			} `json:"skuBase"`
		} `json:"data"`
		ItemIds string `json:"itemIds"`
		Time    int    `json:"time"`
	} `json:"result"`
}

//Batch 详情[批量]
func (goodsItao) Batch(ctx context.Context, GoodsID string) (res *GoodBatchRes, err error) {
	method := "com.alibaba.c2m/ltao.detail.csp.getDetail"

	result, err := server.Post(ctx, method, g.Map{
		"parameters": g.Map{
			"itemIds": GoodsID,
		},
	})
	_ = gjson.New(result).Scan(&res)
	return
}
