package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type addressItao struct {
}

var Address = addressItao{}

type AddressDivisionReq struct {
	Province string `json:"prov,omitempty"`
	City     string `json:"city,omitempty"`
	Area     string `json:"distinct,omitempty"`
	Town     string `json:"town,omitempty"`
	Page     int    `json:"pageIndex"`
	Size     int    `json:"pageSize"`
}
type AddressDivisionRes struct {
	Result struct {
		Result struct {
			Divisions []struct {
				DivisionId    int    `json:"divisionId"`
				DivisionLeaf  bool   `json:"divisionLeaf"`
				DivisionToken string `json:"divisionToken"`
				Level         int    `json:"level"`
				Names         struct {
					EN string `json:"EN"`
					CN string `json:"CN"`
				} `json:"names"`
			} `json:"divisions"`
			PageIndex   int    `json:"pageIndex"`
			PageSize    int    `json:"pageSize"`
			ParentToken string `json:"parentToken"`
			TotalCount  int    `json:"totalCount"`
			TotalPage   int    `json:"totalPage"`
		} `json:"result"`
		Success bool `json:"success"`
	} `json:"result"`
}

func (s addressItao) Division(ctx context.Context, req AddressDivisionReq) (res *AddressDivisionRes, err error) {
	method := "com.alibaba.c2m/ltao.delivery.queryDivision"

	result, err := server.Post(ctx, method, g.Map{
		"param": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
