package ikc

import (
	"context"
	"github.com/gogf/gf/crypto/gmd5"
	"github.com/gogf/gf/encoding/gbase64"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/text/gstr"
	"time"
)

type Config struct {
	ApiUrl    string
	AppKey    string
	AppSecret string
}

var server *Config

const version = "1.0"

const pkgName = "aikucun"

func New(config *Config) {
	server = config
	return
}

type CommonRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
}

func post(ctx context.Context, method string, req interface{}) (res string, err error) {
	Start := gtime.TimestampMilli()
	param := gjson.New(req)
	Url := server.ApiUrl + method
	_ = param.Set("appKey", server.AppKey)
	_ = param.Set("timestamp", gtime.TimestampMilliStr())
	_ = param.Set("version", version)
	_ = param.Set("sign", sign(param))
	Request := g.Client()
	Request.SetHeader("Content-Type", "application/json")
	resp, err := Request.Timeout(time.Second*5).Post(Url, param.MustToJsonString())
	defer func() {
		_ = resp.Close()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", method)
		if err != nil {
			g.Log().Ctx(ctx).Infof("参数【%v】错误【%v】响应时间【%v】", param.MustToJsonString(), err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(pkgName).Infof("参数【%v】响应【%v】响应时间【%v】", param.MustToJsonString(), res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	return
}

func sign(req *gjson.Json) string {
	param := req.MustToJsonString() + server.AppSecret
	param = gbase64.EncodeString(param)
	return gstr.ToUpper(gmd5.MustEncryptString(param))
}
