package hdh

//会订货
import (
	"context"
	"errors"
	"github.com/gogf/gf/crypto/gmd5"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/net/ghttp"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
	"time"
)

var server *Config

const pkgName = "hdh"

type Config struct {
	AppId     string
	AppSecret string
	ApiUrl    string
}

func New(req *Config) {
	server = req
	return
}

func sign(req string) string {
	res := gmd5.MustEncryptString(req + server.AppSecret)
	return res
}

func post(ctx context.Context, method string, req interface{}) (res string, err error) {
	Start := gtime.TimestampMilli()
	reqMap := gconv.Map(req)
	reqMap["appId"] = server.AppId
	param := gjson.New(reqMap)
	Url := server.ApiUrl + method
	Request := g.Client()
	Request.SetHeader("Content-Type", "application/json")
	Request.SetHeader("sign", sign(param.MustToJsonString()))
	resp, err := Request.Timeout(time.Second*5).Post(Url, param.MustToJsonString())
	defer func() {
		_ = resp.Close()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", Url)
		if err != nil {
			g.Log().Ctx(ctx).Infof("参数【%v】错误【%v】响应时间【%v】", param.MustToJsonString(), err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(pkgName).Infof("参数【%v】响应【%v】响应时间【%v】", param.MustToJsonString(), res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	return
}

//检测回调sign
func CheckSign(r *ghttp.Request) (body string, err error) {
	signStr := gconv.String(r.GetHeader("sign"))
	body = r.GetBodyString()
	if sign(body) != signStr {
		err = errors.New("sign错误")
	}
	return
}
