package dwd

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/errors/gerror"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/util/gconv"
	"github.com/gogf/gf/util/gutil"
	"time"
)

type tokenDwd struct {
	AccessToken string
	ExpiresIn   int64
}

var Token = &tokenDwd{}

type TokenGetReq struct {
	Key       string `json:"appid"`
	Secret    string `json:"appsecret"`
	Timestamp int64  `json:"timestamp"`
}

type TokenGetRes struct {
	Errno     int    `json:"errno"`
	Errmsg    string `json:"errmsg"`
	Data      string `json:"data"`
	RequestId string `json:"request_id"`
	Timestamp int    `json:"timestamp"`
	Signature string `json:"signature"`
}

func (s *tokenDwd) Get(ctx context.Context) (res *TokenGetRes, err error) {
	var request = TokenGetReq{
		Key:       server.AppKey,
		Secret:    server.AppSecret,
		Timestamp: gtime.Timestamp(),
	}
	result, err := s.post(ctx, request)
	if err != nil {
		return
	}
	_ = gjson.New(result).Scan(&res)
	return
}

func (s *tokenDwd) Access(ctx context.Context) (res string, err error) {
	conn := g.Redis().Ctx(ctx).Conn()
	defer func() {
		_ = conn.Close()
	}()
	_, _ = conn.DoVar("SELECT", 10)
	cache, _ := conn.DoVar("HGETALL", CacheKey)
	if !cache.IsEmpty() {
		_ = cache.Scan(&s)
		if s.ExpiresIn > gtime.Timestamp() {
			res = s.AccessToken
			return
		}
		_, err = conn.DoVar("DEL", CacheKey)
	}
	result, err := s.Get(ctx)
	if err != nil {
		return
	}
	if result.Errno != 0 {
		err = gerror.New("获取token 失败")
		return
	}
	_ = gjson.New(result.Data).Scan(&s)
	s.ExpiresIn += gtime.Timestamp()
	res = s.AccessToken
	_, _ = conn.Do("HMSET", append(g.Slice{CacheKey}, gutil.MapToSlice(gconv.Map(s))...)...)
	return
}

func (s *tokenDwd) post(ctx context.Context, req interface{}) (res string, err error) {
	Start := gtime.TimestampMilli()

	var request = gjson.New(req)
	_ = request.Set("signature", sign(req))
	Request := g.Client().ContentType("application/x-www-form-urlencoded; charset=utf-8")
	Request.Timeout(3 * time.Second)
	resp, err := Request.Post(server.API+"/token", request.Map())
	defer func() {
		_ = resp.Close()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", "token")
		if err != nil {
			g.Log().Ctx(ctx).Infof("参数【%v】错误【%v】响应时间【%v】", request.MustToJsonString(), err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(PkgName).Infof("参数【%v】响应【%v】响应时间【%v】", request.MustToJsonString(), res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	return
}
