package dwd

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

//物流
type deliveryDwd struct {
}

var Delivery = &deliveryDwd{}

type DeliveryListRes struct {
	Errno     int               `json:"errno"`
	Errmsg    string            `json:"errmsg"`
	Data      *DeliveryListData `json:"data"`
	RequestId string            `json:"request_id"`
	Timestamp int               `json:"timestamp"`
	Signature string            `json:"signature"`
}

type DeliveryListData struct {
	List []struct {
		Name string `json:"name"`
		Code string `json:"code"`
	} `json:"list"`
}

func (*deliveryDwd) List(ctx context.Context) (res *DeliveryListRes, err error) {
	var method = "common.deliveryList"
	result, err := post(ctx, method, g.Map{})
	if err != nil {
		return
	}
	res = &DeliveryListRes{
		Errno:     result.Errno,
		Errmsg:    result.Errmsg,
		RequestId: result.RequestId,
		Timestamp: result.Timestamp,
		Signature: result.Signature,
	}
	_ = gjson.New(result.Data).Scan(&res.Data)
	return
}
