package suning

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type QueryMessageReq struct {
	SnRequest struct {
		SnBody struct {
			QueryQuerymessage struct {
				MsgType  string `json:"msgType"`
				PageNo   string `json:"pageNo"`
				PageSize string `json:"pageSize"`
			} `json:"queryQuerymessage"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type QueryMessageRes struct {
	SnResponseContent struct {
		SnHead struct {
			TotalSize     string `json:"totalSize"`
			PageTotal     string `json:"pageTotal"`
			PageNo        string `json:"pageNo"`
			ReturnMessage string `json:"returnMessage"`
		} `json:"sn_head"`
		SnBody struct {
			QueryQuerymessage []struct {
				MsgType string `json:"msgType"`
				MsgList []struct {
					Opt          string `json:"opt"`
					OrderNo      string `json:"orderNo"`
					ProductCode  string `json:"productCode"`
					CreateTime   string `json:"createTime"`
					Channel      string `json:"channel"`
					OrderItemNo  string `json:"orderItemNo"`
					Id           string `json:"id"`
					SupplierCode string `json:"supplierCode"`
					Status       string `json:"status"`
					Afterchanged []struct {
						SecondPid string `json:"secondPid"`
						SnId      string `json:"snId"`
						Level     string `json:"level"`
						Name      string `json:"name"`
						Pid       string `json:"pid"`
						Id        string `json:"id"`
					} `json:"afterchanged"`
					BeforeChanged []struct {
						SecondPid string `json:"secondPid"`
						SnId      string `json:"snId"`
						Level     string `json:"level"`
						Name      string `json:"name"`
						Pid       string `json:"pid"`
						Id        string `json:"id"`
					} `json:"beforeChanged"`
				} `json:"msgList"`
			} `json:"queryQuerymessage"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

// 获取订单状态
func QueryMessage(ctx context.Context, msgType, pageNo, pageSize string) (res QueryMessageRes, err error) {
	params := QueryMessageReq{}
	params.SnRequest.SnBody.QueryQuerymessage.MsgType = msgType
	params.SnRequest.SnBody.QueryQuerymessage.PageNo = pageNo
	params.SnRequest.SnBody.QueryQuerymessage.PageSize = pageSize
	result, err := post(ctx, "suning.sngoods.querymessage.query", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type MessageDelReq struct {
	SnRequest struct {
		SnBody struct {
			DeleteMessage struct {
				MsgType string                  `json:"msgType"`
				MsgList []*MessageDelReqMsgList `json:"msgList"`
			} `json:"deleteMessage"`
		} `json:"sn_body"`
	} `json:"sn_request"`
}

type MessageDelReqMsgList struct {
	Id string `json:"id"`
}

type MessageDelRes struct {
	SnResponseContent struct {
		SnBody struct {
			DeleteMessage struct {
				DeleteResult string `json:"deleteResult"`
			} `json:"deleteMessage"`
		} `json:"sn_body"`
	} `json:"sn_responseContent"`
}

func MessageDel(ctx context.Context, msgType string, msgList []*MessageDelReqMsgList) (res MessageDelRes, err error) {
	params := MessageDelReq{}
	params.SnRequest.SnBody.DeleteMessage.MsgType = msgType
	params.SnRequest.SnBody.DeleteMessage.MsgList = msgList
	result, err := post(ctx, "suning.sngoods.message.delete", params)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
