package ikc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type addressIkc struct {
}

//Address 地址
var Address = addressIkc{}

type AddressProvinceRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		ProvinceCode string `json:"provinceCode"`
		ProvinceName string `json:"provinceName"`
	} `json:"data"`
}

//Province 省
func (addressIkc) Province(ctx context.Context) (res *AddressProvinceRes, err error) {
	method := "address/v2/queryProvince"
	result, err := post(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}

type AddressCityRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		CityName string `json:"cityName"`
		CityCode string `json:"cityCode"`
	} `json:"data"`
}

//City 市
func (addressIkc) City(ctx context.Context, code string) (res *AddressCityRes, err error) {
	method := "address/v2/queryCity"
	result, err := post(ctx, method, g.Map{
		"provinceCode": code,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type AddressAreaRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		AreaCode string `json:"areaCode"`
		AreaName string `json:"areaName"`
	} `json:"data"`
}

//Area 区
func (addressIkc) Area(ctx context.Context, code string) (res *AddressAreaRes, err error) {
	method := "address/v2/queryArea"
	result, err := post(ctx, method, g.Map{
		"cityCode": code,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
