package yonghui

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

var Order = new(order)

type order struct {
}

type OrderCreateGoodsInfo struct {
	GoodsCode  string `json:"goodsCode"`
	GoodsPrice string `json:"goodsPrice"`
	GoodsQty   int    `json:"goodsQty"`
}

type OrderCreateReq struct {
	DeliveryType   int                     `json:"deliveryType"`
	ThirdOrderCode string                  `json:"thirdOrderCode"`
	CreateMode     int                     `json:"createMode"`
	ReceiveDate    string                  `json:"receiveDate"`
	OrderAmount    string                  `json:"orderAmount"`
	GoodsAmount    string                  `json:"goodsAmount"`
	FreightAmount  string                  `json:"freightAmount"`
	OrderRemark    string                  `json:"orderRemark"`
	UseCreditPay   int                     `json:"useCreditPay"`
	UserTelephone  string                  `json:"userTelephone"`
	GoodsInfos     []*OrderCreateGoodsInfo `json:"goodsInfos"`
	ReceiverInfo   struct {
		Name      string `json:"name"`
		Prov      string `json:"prov"`
		City      string `json:"city"`
		Area      string `json:"area"`
		Address   string `json:"address"`
		Telephone string `json:"telephone"`
	} `json:"receiverInfo"`
}

type OrderCreateRes struct {
	Success bool        `json:"success"`
	Code    string      `json:"code"`
	Message string      `json:"message"`
	Data    interface{} `json:"data"`
}

/**
创建订单
*/
func (s *order) Create(ctx context.Context, req *OrderCreateReq) (res *OrderCreateRes, err error) {

	result, err := post(ctx, "com.csx.order-save.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderConfirmReq struct {
	OrderCode      string `json:"orderCode"`
	ThirdOrderCode string `json:"thirdOrderCode"`
	UseCreditPay   string `json:"useCreditPay"`
}

type OrderConfirmRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    string `json:"data"`
}

/**
确认订单
*/
func (s *order) Confirm(ctx context.Context, req *OrderConfirmReq) (res *OrderConfirmRes, err error) {

	result, err := post(ctx, "com.csx.order-confirm.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderDetailReq struct {
	OrderCode      string `json:"orderCode"`
	ThirdOrderCode string `json:"thirdOrderCode"`
}

type OrderDetailRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    struct {
		ThirdOrderCode  string `json:"thirdOrderCode"`
		CsxOrderCode    string `json:"csxOrderCode"`
		IsSplit         int    `json:"isSplit"`
		CreateTime      string `json:"createTime"`
		Freight         string `json:"freight"`
		OrderPrice      string `json:"orderPrice"`
		OrderStatus     int    `json:"orderStatus"`
		DeliveryType    int    `json:"deliveryType"`
		PayTime         string `json:"payTime"`
		ReceiverAddress string `json:"receiverAddress"`
		ReceiverName    string `json:"receiverName"`
		ReceiverPhone   string `json:"receiverPhone"`
		UserName        string `json:"userName"`
		UserTelephone   string `json:"userTelephone"`
		OrderType       int    `json:"orderType"`
		PushType        string `json:"pushType"`
		ShipTime        string `json:"shipTime"`
		GoodsDetails    []struct {
			ClassCode  string  `json:"classCode"`
			ClassName  string  `json:"className"`
			GoodsCode  string  `json:"goodsCode"`
			GoodsQty   int     `json:"goodsQty"`
			GoodsImage string  `json:"goodsImage"`
			GoodsName  string  `json:"goodsName"`
			GoodsPrice int     `json:"goodsPrice"`
			GoodsSpec  string  `json:"goodsSpec"`
			GoodsUnit  string  `json:"goodsUnit"`
			NetPrice   float64 `json:"netPrice"`
			TaxPrice   int     `json:"taxPrice"`
			TaxRate    int     `json:"taxRate"`
			TotalPrice int     `json:"totalPrice"`
		} `json:"goodsDetails"`
		PayDetails []struct {
			PayAmount int    `json:"payAmount"`
			PayCode   string `json:"payCode"`
			PayType   string `json:"payType"`
		} `json:"payDetails"`
		SubOrderDetails []struct {
			CsxSubOrderCode string `json:"csxSubOrderCode"`
			OrderStatus     string `json:"orderStatus"`
			GoodsDetails    []struct {
				ClassCode  string  `json:"classCode"`
				ClassName  string  `json:"className"`
				GoodsCode  string  `json:"goodsCode"`
				GoodsQty   int     `json:"goodsQty"`
				GoodsImage string  `json:"goodsImage"`
				GoodsName  string  `json:"goodsName"`
				GoodsPrice float64 `json:"goodsPrice"`
				GoodsSpec  string  `json:"goodsSpec"`
				GoodsUnit  string  `json:"goodsUnit"`
				NetPrice   float64 `json:"netPrice"`
				TaxPrice   float64 `json:"taxPrice"`
				TaxRate    int     `json:"taxRate"`
				TotalPrice float64 `json:"totalPrice"`
			} `json:"goodsDetails"`
		} `json:"subOrderDetails"`
	} `json:"data"`
}

/**
订单详情
*/
func (s *order) Detail(ctx context.Context, req *OrderDetailReq) (res *OrderDetailRes, err error) {

	result, err := post(ctx, "com.csx.order-detail.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderQueryReq struct {
	ThirdOrderCode string `json:"thirdOrderCode"`
}

type OrderQueryRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    int64  `json:"data"`
}

/**
反查订单
*/
func (s *order) Query(ctx context.Context, req *OrderQueryReq) (res *OrderQueryRes, err error) {

	result, err := post(ctx, "com.csx.order-query.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderReceiveReq struct {
	CsxOrderCode   string `json:"csxOrderCode"`
	ThirdOrderCode string `json:"thirdOrderCode"`
}

type OrderReceiveRes struct {
	Success bool        `json:"success"`
	Code    string      `json:"code"`
	Message string      `json:"message"`
	Data    interface{} `json:"data"`
}

/**
签收订单
*/
func (s *order) Receive(ctx context.Context, req *OrderReceiveReq) (res *OrderReceiveRes, err error) {

	result, err := post(ctx, "com.csx.order-sign.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderCancelReq struct {
	ThirdOrderCode  string `json:"thirdOrderCode "`
	CsxOrderCode    string `json:"csxOrderCode"`
	CsxSubOrderCode string `json:"csxSubOrderCode "`
}

type OrderCancelRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    struct {
		ThirdOrderCode string `json:"thirdOrderCode"`
		OrderCode      string `json:"orderCode"`
		SubOrderCode   string `json:"subOrderCode"`
		GoodsInfo      []struct {
			GoodsCode string `json:"goodsCode"`
			GoodsQty  int    `json:"goodsQty"`
		} `json:"goodsInfo"`
	} `json:"data"`
}

/**
取消订单
*/
func (s *order) Cancel(ctx context.Context, req *OrderCancelReq) (res *OrderCancelRes, err error) {

	result, err := post(ctx, "com.csx.order-cancel.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderLogisticsReq struct {
	ThirdOrderCode string `json:"thirdOrderCode"`
	CsxOrderCode   string `json:"csxOrderCode"`
	LogisticCode   string `json:"logisticCode"`
}

type OrderLogisticsRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    []struct {
		ThirdOrderCode string `json:"thirdOrderCode"`
		CsxOrderCode   string `json:"csxOrderCode"`
		LogisticCode   string `json:"logisticCode"`
		ItemList       []struct {
			LogisticsCompany string `json:"logisticsCompany"`
			LogisticsCode    string `json:"logisticsCode"`
			State            string `json:"state"`
			StateEx          string `json:"stateEx"`
			Location         string `json:"location"`
			Traces           []struct {
				AcceptTime    string `json:"acceptTime"`
				AcceptStation string `json:"acceptStation"`
				Location      string `json:"location"`
				Action        string `json:"action"`
				Remark        string `json:"remark,omitempty"`
			} `json:"traces"`
			GoodsInfos []struct {
				GoodsCode string `json:"goodsCode"`
				GoodsName string `json:"goodsName"`
				OutCount  string `json:"outCount"`
			} `json:"goodsInfos"`
		} `json:"itemList"`
	} `json:"data"`
}

/**
查询物流
*/
func (s *order) Logistics(ctx context.Context, req *OrderLogisticsReq) (res *OrderLogisticsRes, err error) {

	result, err := post(ctx, "com.csx.logistics-query.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}

type OrderFreightGoodsInfos struct {
	GoodsCode string `json:"goodsCode"`
	GoodsQty  int    `json:"goodsQty"`
}

type OrderFreightReq struct {
	DeliveryType    int                       `json:"deliveryType"`
	GoodsInfos      []*OrderFreightGoodsInfos `json:"goodsInfos"`
	ReceiverAddress struct {
		Prov    string `json:"prov"`
		City    string `json:"city"`
		Area    string `json:"area"`
		Address string `json:"address"`
	} `json:"receiverAddress"`
}

type OrderFreightRes struct {
	Success bool   `json:"success"`
	Code    string `json:"code"`
	Message string `json:"message"`
	Data    struct {
		Freight           string  `json:"freight"`
		Weight            float64 `json:"weight"`
		FreightInfoDetail struct {
			Field1 []struct {
				GoodsFreightType string `json:"goodsFreightType"`
				FreightInfo      struct {
					FreightStandard  string `json:"freightStandard"`
					FreeShipPrice    string `json:"freeShipPrice"`
					FreightNeedAddOn bool   `json:"freightNeedAddOn"`
					FreightAddOnMsg  string `json:"freightAddOnMsg"`
					GoodsAmount      string `json:"goodsAmount"`
					AddOnAmount      string `json:"addOnAmount"`
					FreightAmount    string `json:"freightAmount"`
				} `json:"freightInfo"`
				GoodsInfo []struct {
					GoodsCode  string `json:"goodsCode"`
					GoodsWight string `json:"goodsWight"`
				} `json:"goodsInfo"`
			} `json:"0"`
		} `json:"freightInfoDetail"`
	} `json:"data"`
}

/**
订单运费
*/
func (s *order) Freight(ctx context.Context, req *OrderFreightReq) (res *OrderFreightRes, err error) {

	result, err := post(ctx, "com.csx.order-freight-compute.do", req)
	if nil != err {
		return
	}
	err = gjson.New(result).Scan(&res)
	return
}
