package schl

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/util/gconv"
)

type logisticsLogic struct {
}

var Logistics = logisticsLogic{}

type LogisticsTraceReq struct {
	UnionNo string `json:"unionNo"`
	ExpNo   string `json:"expNo"`
}

type LogisticsTraceRes struct {
	CommonRes
	Result struct {
		Courier        string `json:"courier"`
		CourierPhone   string `json:"courierPhone"`
		DeliveryStatus int    `json:"deliverystatus"`
		ExpName        string `json:"expName"`
		ExpPhone       string `json:"expPhone"`
		List           []struct {
			Time   string `json:"time"`
			Status string `json:"status"`
		} `json:"list"`
		Number string `json:"number"`
		Type   string `json:"type"`
	} `json:"result"`
	TraceId string `json:"traceId"`
}

func (s *Config) LogisticsTrace(ctx context.Context, req LogisticsTraceReq) (res *LogisticsTraceRes, err error) {
	result, err := s.Post(ctx, "/open/xdxt/api/v2/order/queryExpTrack", gconv.Map(req))
	if err != nil {
		return
	}

	err = gjson.New(result).Scan(&res)
	return
}
