package wpc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type orderWpc struct {
}

var Order = orderWpc{}

type OrderListReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
	Page       string `json:"page"`
	PageSize   string `json:"pageSize"`
}
type OrderListRes struct {
}

//List 列表
func (orderWpc) List(ctx context.Context, req OrderListReq) (res *OrderListRes, err error) {
	method := "getSimpleOrderListV2"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderDetailReq struct {
	ChannelId  string `json:"vopChannelId"`
	UserNumber string `json:"userNumber"`
}

type OrderDetailRes struct {
	ReturnCode    string      `json:"returnCode"`
	ReturnMessage string      `json:"returnMessage"`
	Result        interface{} `json:"result"`
}

//Detail 详情
func (orderWpc) Detail(ctx context.Context, req OrderDetailReq) (res *OrderDetailRes, err error) {
	method := "getOrderDetail"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type OrderCreateReq struct {
	ChannelId       string `json:"vopChannelId"`
	UserNumber      string `json:"userNumber"`
	AreaId          string `json:"areaId,omitempty"`
	ProvinceName    string `json:"provinceName,omitempty"`
	CityName        string `json:"cityName,omitempty"`
	AreaName        string `json:"areaName,omitempty"`
	TownName        string `json:"townName,omitempty"`
	Address         string `json:"address"`
	Consignee       string `json:"consignee"`
	Mobile          string `json:"mobile"`
	OrderSn         string `json:"channelOrderSn"`
	IsUseCipher     string `json:"isUseCipher"`
	AddressCipher   string `json:"addressCipher,omitempty"`   //详细地址加密, 加密类型:RSA2048
	ConsigneeCipher string `json:"consigneeCipher,omitempty"` //收件人加密, 加密类型:RSA2048
	MobileCipher    string `json:"mobileCipher,omitempty"`    //收件人手机号加密, 加密类型:RSA2048
	SizeInfo        string `json:"sizeInfo"`
}

type OrderCreateSizeInfo struct {
	AdID       int    `json:"adId"`
	SizeID     int64  `json:"sizeId"`
	SizeNum    int    `json:"sizeNum"`
	CouponCode string `json:"couponCode"`
}

type OrderCreateRes struct {
	ReturnCode    string `json:"returnCode"`
	ReturnMessage string `json:"returnMessage"`
	Result        struct {
		Orders []struct {
			OrderSn     string
			IsUseCoupon bool
		}
		CouponList []struct {
			CouponNo        string
			CouponSn        string
			OrderSn         string
			GetCouponStatus int
			GetCouponReason string
			UseCouponStatus int
			UseCouponReason string
		}
	} `json:"result"`
}

//Create 下单
func (orderWpc) Create(ctx context.Context, req OrderCreateReq) (res *OrderCreateRes, err error) {
	method := "orderCreate2Pms"
	req.ChannelId = server.AppKey
	req.UserNumber = server.UserNumber
	result, err := post(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
