package aliNew

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type addressAli struct {
}

var Address = addressAli{}

type AddressParseRes struct {
	Result struct {
		Address     string `json:"address"`
		AddressCode string `json:"addressCode"`
		IsDefault   bool   `json:"isDefault"`
		Latest      bool   `json:"latest"`
		PostCode    string `json:"postCode"`
	} `json:"result"`
}

type AddressGetRes struct {
	CommonRes
	Result struct {
		Code       string   `json:"code"`
		Name       string   `json:"name"`
		ParentCode string   `json:"parentCode"`
		Post       string   `json:"post"`
		Children   []string `json:"children"`
	} `json:"result"`
}
type AddressGetChildRes struct {
	CommonRes
	Result []struct {
		Code       string `json:"code"`
		Name       string `json:"name"`
		ParentCode string `json:"parentCode"`
	} `json:"result"`
}

//Parse 根据地址解析地区码
func (s *addressAli) Parse(ctx context.Context, req string) (res *AddressParseRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.addresscode.parse"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"addressInfo":  req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//Get 获取交易地址代码表详情
func (s *addressAli) Get(ctx context.Context, Code string) (res *AddressGetRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.addresscode.get"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"areaCode":     Code,
		"webSite":      WebSite,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//GetChild 获取交易地址的下一级信息
func (s *addressAli) GetChild(ctx context.Context, Code string) (res *AddressGetChildRes, err error) {
	method := "com.alibaba.trade/alibaba.trade.addresscode.getchild"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"areaCode":     Code,
		"webSite":      WebSite,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
