package nsq


type CommonReq struct {
	MsgType        int     `json:"msgType"`
	MsgData        string  `json:"msgData"`
	Source         int     `json:"source"`
	MsgSendTime    int64   `json:"msgSendTime"`
}


type CommonReply struct {
	Success interface{} `json:"success"`
	Msg     string      `json:"msg"`
	Data    interface{} `json:"data"`
	Code    int         `json:"code"`
}

type NotifyReqData struct {
	RealSource  int    `json:"real_source"`
	Source      int    `json:"source"`
	Type        int    `json:"type"`
	CreatedTime int    `json:"created_time"`
	Result      string `json:"result"`
}

type NotifyReq struct {
	Id   int           `json:"id"`
	Type string        `json:"type"`
	Data NotifyReqData `json:"data"`
}

type NotifyRes struct {
	Code int    `json:"code"`
	Msg  string `json:"msg"`
}
type NotifyResNew struct {
	Msg string `json:"message"`
}

type NotifyRefundData struct {
	AfsServiceId   string `json:"afsServiceId"`
	State          int    `json:"state"`
	AfterSrvStatus string `json:"after_srv_status"`
}

