package hdh

import (
	"context"
	"encoding/json"
	"github.com/gogf/gf/net/ghttp"
)

type GoodsNotifyRes struct {
	BrandID            string             `json:"brandId"`            //
	BrandName          string             `json:"brandName"`          //品牌名称
	Currency           string             `json:"currency"`           //货币单位 参考货币字典
	FirstCateID        int                `json:"firstCateId"`        //一级类目id
	FirstCateName      string             `json:"firstCateName"`      //一级类目名称
	Gift               int                `json:"gift"`               //是或赠品( 0不是 1是)
	ID                 string             `json:"id"`                 //
	ImageList          []string           `json:"imageList"`          //图片数组
	IsDelete           int                `json:"isDelete"`           //
	ItemLimitCondition ItemLimitCondition `json:"itemLimitCondition"` //商品限购信息
	Name               string             `json:"name"`               //商品名称
	Presell            int                `json:"presell"`            //是否预售商品(0不是 1是)
	SecondCateID       int                `json:"secondCateId"`       //二级类目id
	SecondCateName     string             `json:"secondCateName"`     //二级类目名称
	ShelfStatus        int                `json:"shelfStatus"`        //商品上下架状态(0下架 1上架) 下架商品即为不可售
	ShopName           string             `json:"shopName"`           //店铺名称
	SkuList            []SkuList          `json:"skuList"`            //商品规格信息
	SkuNameValues      []SkuNameValues    `json:"skuNameValues"`      //规格信息
	ThirdCateID        int                `json:"thirdCateId"`        //
	ThirdCateName      string             `json:"thirdCateName"`      //
	RichDesc           string             `json:"richDesc"`           //图文详情 html片段
}
type ItemLimitCondition struct {
	CycleLimitQuantity int `json:"cycleLimitQuantity"` //周期限购数量
	CycleLimitTime     int `json:"cycleLimitTime"`     //周期限购时间（默认单位：日）
}
type SkuChannels struct {
	ChannelName   string  `json:"channelName"`   //渠道名称
	ChannelType   string  `json:"channelType"`   //渠道类型
	ItemCode      string  `json:"itemCode"`      //商品编码 如果系统需要在会订货系统导入
	OriginalPrice float64 `json:"originalPrice"` //原价
	Price         float64 `json:"price"`         //现价
	SalesStatus   int     `json:"salesStatus"`   //商品销售状态(0为不可售 1可售)
	Stock         int     `json:"stock"`         //当前渠道商品的库存数
}
type SkuValues struct {
	SkuName  string `json:"skuName"`  //规格名
	SkuValue string `json:"skuValue"` //规格值
}
type SkuList struct {
	ItemID       string        `json:"itemId"`       //商品id 与上面的商品id一致
	SkuChannels  []SkuChannels `json:"skuChannels"`  //对应渠道信息
	SkuID        string        `json:"skuId"`        //规格id
	SkuValues    []SkuValues   `json:"skuValues"`    //规格信息
	TotalStock   int           `json:"totalStock"`   //商品总数量
	Unit         string        `json:"unit"`         //单位 例如：件、组、盒、支
	UnitQuantity int           `json:"unitQuantity"` //单位对应的数量 与单位共用 如：1件、1组、1盒、1支
	Upc          string        `json:"upc"`          //
	Weight       float64       `json:"weight"`       //重量
	WeightG      float64       `json:"weightG"`      //
}

type SkuNameValues struct {
	SkuName   string      `json:"skuName"`   //
	SkuValues []SkuValues `json:"skuValues"` //规格信息
}

//商品请求
type GoodsListReq struct {
	AppID         string  `json:"appId"`
	Page          int     `json:"page"`
	Limit         int     `json:"limit"`
	LogNo         string  `json:"logNo"`         //日志编号
	PrePageLastID string  `json:"prePageLastId"` //上一页最后一个商品ID
	CateID1       int     `json:"cateId1"`       //一级类目ID
	CateID2       int     `json:"cateId2"`       //二级类目ID
	CateID3       int     `json:"cateId3"`       //三级类目ID
	ChannelTypes  []int   `json:"channelTypes"`  //品牌ID集合
	BrandIds      []int64 `json:"brandIds"`      //发货方式集合
}

//商品列表
type GoodsListRes struct {
	Code string `json:"code"`
	Data struct {
		ItemList []struct {
			BrandID        string   `json:"brandId"`        //品牌ID
			BrandName      string   `json:"brandName"`      //品牌名称
			Currency       string   `json:"currency"`       //货币单位 参考货币字典
			Desc           string   `json:"desc"`           //商品描述
			FirstCateID    int      `json:"firstCateId"`    //一级类目id
			FirstCateName  string   `json:"firstCateName"`  //
			Gift           int      `json:"gift"`           //是或赠品( 0不是 1是)
			ID             string   `json:"id"`             //
			ImageList      []string `json:"imageList"`      //图片数组
			IsDelete       int      `json:"isDelete"`       //
			Name           string   `json:"name"`           //商品名称
			Presell        int      `json:"presell"`        //是否预售商品(0不是 1是)
			RichDesc       string   `json:"richDesc"`       //图文详情 html片段
			SecondCateID   int      `json:"secondCateId"`   //二级类目id
			SecondCateName string   `json:"secondCateName"` //
			ShelfStatus    int      `json:"shelfStatus"`    //商品上下架状态(0下架 1上架) 下架商品即为不可售
			ShopName       string   `json:"shopName"`       //店铺名称
			SkuList        []struct {
				ItemID      string `json:"itemId"` //商品id 与上面的商品id一致
				SkuChannels []struct {
					ChannelName   string  `json:"channelName"`   //渠道名称
					ChannelType   string  `json:"channelType"`   //渠道类型
					ItemCode      string  `json:"itemCode"`      //商品编码 如果系统需要在会订货系统导入订单 需要使用到
					OriginalPrice float64 `json:"originalPrice"` //原价（建议零售价）
					Price         float64 `json:"price"`         //现价（实际采购价）
					SalesStatus   int     `json:"salesStatus"`   //商品销售状态(0为不可售 1可售)
					Stock         int     `json:"stock"`         //当前渠道商品的库存数
				} `json:"skuChannels"` //对应渠道信息
				SkuID     string `json:"skuId"` //规格id
				SkuValues []struct {
					ImageURL string `json:"imageUrl"` //规格对应的图片数组
					SkuName  string `json:"skuName"`  //规格名称
					SkuValue string `json:"skuValue"` //规格名对应的规格信息
				} `json:"skuValues"` //规格值
				TotalStock   int     `json:"totalStock"`   //商品总数量
				Unit         string  `json:"unit"`         //单位 例如：件、组、盒、支
				UnitQuantity int     `json:"unitQuantity"` //单位对应的数量 与单位共用 如：1件、1组、1盒、1支
				Upc          string  `json:"upc"`          //
				Weight       float64 `json:"weight"`       //重量
				WeightG      float64 `json:"weightG"`      //
			} `json:"skuList"` //商品规格信息
			SkuNameValues []struct {
				SkuName   string     `json:"skuName"` //规格名称
				SkuValues []struct { //规格名对应的规格信息
					ImageURLList []string `json:"imageUrlList"` //规格对应的图片数组
					SkuValue     string   `json:"skuValue"`     //规格值
				} `json:"skuValues"`
			} `json:"skuNameValues"`
			ThirdCateID   int    `json:"thirdCateId"`
			ThirdCateName string `json:"thirdCateName"`
		} `json:"itemList"`
		Total int `json:"total"`
	} `json:"data"`
	Message string `json:"message"`
	Success int    `json:"success"`
}

//商品详情入参
type GoodsInfoReq struct {
	AppID string   `json:"appId"`
	Ids   []string `json:"ids"` //商品Id
}

//商品详情
type GoodsInfoRes struct {
	Code string `json:"code"`
	Data []struct {
		BrandID        string   `json:"brandId"`
		BrandName      string   `json:"brandName"`      //品牌名称
		Currency       string   `json:"currency"`       //货币单位 参考货币字典
		Desc           string   `json:"desc"`           //商品描述
		FirstCateID    int      `json:"firstCateId"`    //一级类目id
		FirstCateName  string   `json:"firstCateName"`  //
		Gift           int      `json:"gift"`           //是或赠品( 0不是 1是)
		ID             string   `json:"id"`             //
		ImageList      []string `json:"imageList"`      //图片数组
		IsDelete       int      `json:"isDelete"`       //
		Name           string   `json:"name"`           //商品名称
		Presell        int      `json:"presell"`        //是否预售商品(0不是 1是)
		RichDesc       string   `json:"richDesc"`       //图文详情 html片段
		SecondCateID   int      `json:"secondCateId"`   //二级类目id
		SecondCateName string   `json:"secondCateName"` //
		ShelfStatus    int      `json:"shelfStatus"`    //商品销售状态(0为不可售 1可售)
		ShopName       string   `json:"shopName"`       //店铺名称
		SkuList        []struct {
			ItemID      string `json:"itemId"` //商品id 与上面的商品id一致
			SkuChannels []struct {
				ChannelName   string  `json:"channelName"`   //渠道名称
				ChannelType   string  `json:"channelType"`   //渠道类型
				ItemCode      string  `json:"itemCode"`      //商品编码 如果系统需要在会订货系统导入订单 需要使用到
				OriginalPrice float64 `json:"originalPrice"` //原价（建议零售价）
				Price         float64 `json:"price"`         //现价（实际采购价）
				SalesStatus   int     `json:"salesStatus"`   //商品销售状态(0为不可售 1可售)
				Stock         int     `json:"stock"`         //当前渠道商品的库存数
			} `json:"skuChannels"` //对应渠道信息
			SkuID     string `json:"skuId"` //规格id
			SkuValues []struct {
				ImageURL string `json:"imageUrl"` //规格对应的图片数组
				SkuName  string `json:"skuName"`  //规格名称
				SkuValue string `json:"skuValue"` //规格名对应的规格信息
			} `json:"skuValues"` //规格值
			TotalStock   int     `json:"totalStock"`   //商品总数量
			Unit         string  `json:"unit"`         //单位 例如：件、组、盒、支
			UnitQuantity int     `json:"unitQuantity"` //单位对应的数量 与单位共用 如：1件、1组、1盒、1支
			Upc          string  `json:"upc"`          //
			Weight       float64 `json:"weight"`       //重量
			WeightG      float64 `json:"weightG"`      //
		} `json:"skuList"`
		SkuNameValues []struct {
			SkuName   string `json:"skuName"` //规格名称
			SkuValues []struct {
				ImageURLList []string `json:"imageUrlList"` //规格对应的图片数组
				SkuValue     string   `json:"skuValue"`     //规格值
			} `json:"skuValues"` //
		} `json:"skuNameValues"` //
		ThirdCateID   int    `json:"thirdCateId"`   //
		ThirdCateName string `json:"thirdCateName"` //
	} `json:"data"` //
	Message string `json:"message"`
	Success int    `json:"success"`
}

//商品列表
func GetGoodsList(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {

	result, err := post(ctx, "/item/get_item_list.do", req)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

//商品详情
func GetGoodsInfo(ctx context.Context, req *GoodsInfoReq) (res *GoodsInfoRes, err error) {

	result, err := post(ctx, "/item/get_items.do", req)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(result), &res)
	return
}

//商品回调
func GoodsCallBack(r *ghttp.Request) (res *GoodsNotifyRes, err error) {
	body, err := CheckSign(r)
	if nil != err {
		return
	}
	err = json.Unmarshal([]byte(body), &res)
	return
}
