package ikc

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type categoryIkc struct {
}

//Category 品类
var Category = categoryIkc{}

type CategoryListRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		Id   string `json:"id"`
		Name string `json:"name"`
		Sort int    `json:"sort"`
	} `json:"data"`
}

//List 列表
func (*categoryIkc) List(ctx context.Context) (res *CategoryListRes, err error) {
	method := "category/frontCategory"
	result, err := post(ctx, method, g.Map{})
	_ = gjson.New(result).Scan(&res)
	return
}

type CategoryTreeRes struct {
	ResultCode    int    `json:"resultCode"`
	ResultMessage string `json:"resultMessage"`
	Data          []struct {
		Pid            string `json:"pid"`
		ParentId       string `json:"parentId"`
		CategoryCode   string `json:"categoryCode"`
		CategoryName   string `json:"categoryName"`
		CategoryNameEn string `json:"categoryNameEn,omitempty"`
		CategoryLevel  int    `json:"categoryLevel"`
		OrderNo        int    `json:"orderNo"`
	} `json:"data"`
}

//Tree 类目树
func (*categoryIkc) Tree(ctx context.Context, level interface{}) (res *CategoryTreeRes, err error) {
	method := "category/getTree"
	result, err := post(ctx, method, g.Map{
		"level": gconv.Int(level),
	})
	_ = gjson.New(result).Scan(&res)
	return
}
