package ali

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
)

type deliverAli struct {
}

var Deliver = deliverAli{}

type DeliverInfosRes struct {
	CommonRes
	Result []struct {
		Sender struct {
			SenderName         string `json:"senderName"`
			SenderMobile       string `json:"senderMobile"`
			Encrypt            string `json:"encrypt"`
			SenderProvinceCode string `json:"senderProvinceCode"`
			SenderCityCOde     string `json:"senderCityC  ode"`
			SenderCountyCode   string `json:"senderCountyCode"`
			SenderAddress      string `json:"senderAddress"`
			SenderProvince     string `json:"senderProvince"`
			SenderCity         string `json:"senderCity"`
			SenderCounty       string `json:"senderCounty"`
		} `json:"sender"`
		OrderEntryIds   string `json:"orderEntryIds"`
		LogisticsBillNo string `json:"logisticsBillNo"`
		LogisticsId     string `json:"logisticsId  "`
		Receiver        struct {
			ReceiverName         string `json:"receiverName"`
			ReceiverPhone        string `json:"receiverPhone"`
			ReceiverMobile       string `json:"receiverMobile"`
			Encrypt              string `json:"encrypt"`
			ReceiverProvinceCode string `json:"receiverProvinceCode"`
			ReceiverCityCode     string `json:"receiverCityCode"`
			ReceiverCountyCode   string `json:"receiverCountyCode"`
			ReceiverAddresS      string `json:"receiverAddres  s"`
			ReceiverProvince     string `json:"receiverProvince"`
			ReceiverCity         string `json:"receiverCity"`
			ReceiverCounty       string `json:"receiverCounty"`
		} `json:"receiver"`
		LogisticsCompanyName string `json:"logisticsCompanyName"`
		Status               string `json:"status"`
		SendGoods            []struct {
			GoodName string `json:"goodName"`
			Quantity string `json:"quantity"`
			Unit     string `json:"unit"`
		} `json:"sendGoods"`
		Remarks            string `json:"remarks"`
		LogisticsCompanyId string `json:"logisticsCompanyId"`
	} `json:"result"`
}

type DeliverTraceRes struct {
	CommonRes
	LogisticsTrace []struct {
		LogisticsId     string `json:"logisticsId"`
		OrderId         int64  `json:"orderId"`
		LogisticsBillNo string `json:"logisticsBillNo"`
		LogisticsSteps  []struct {
			AcceptTime string `json:"acceptTime"`
			Remark     string `json:"remark"`
		} `json:"logisticsSteps"`
	} `json:"logisticsTrace"`
}

//Info 物流详情
func (*deliverAli) Info(ctx context.Context, orderSn string) (res *DeliverInfosRes, err error) {
	method := "com.alibaba.logistics/alibaba.trade.getLogisticsInfos.buyerView"
	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"webSite":      WebSite,
		"orderId":      orderSn,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

//Trace 物流轨迹
func (*deliverAli) Trace(ctx context.Context, orderSn string) (res *DeliverTraceRes, err error) {
	method := "com.alibaba.logistics/alibaba.trade.getLogisticsTraceInfo.buyerView"
	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"webSite":      WebSite,
		"orderId":      orderSn,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
