package logs

import (
	"fmt"
	"github.com/gogf/gf/errors/gerror"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/glog"
	"github.com/kjk/betterguid"
)


type RequestLogReq struct {
	Path         string //存储路径
	RequestURI   string //请求URI
	RequestID    string //请求RequestID
	Method       string //请求方法
	Params       string //请求参数
	Response     string //响应参数
	Err          error  //错误信息
	ServerName   string //请求服务名称
	ResponseTime int64  //响应时间 毫秒级
}



//统一请求日志 20211208 gk
func RequestLog(req RequestLogReq){
	if req.Err != nil {
		Error("%+v",gerror.Wrap(req.Err, req.RequestID))
	}else{
		Info(req.Path,  "请求ID:【%v】 服务名称: 【%v】 请求路径:【%v】 请求方法: 【%v】 请求参数: 【%v】 响应参数: 【%v】 响应时间:【%v ms】error:【%v】",
			req.RequestID, req.ServerName, req.RequestURI, req.Method, req.Params,req.Response, req.ResponseTime, nil)
	}
}

//记录info日志 20211208 gk
func Info(path string,format string, v ...interface{}) {
	newPath := g.Log().GetPath() + "/" + path
	glog.Path(newPath).File( "info-{Ymd}.log").Println(fmt.Sprintf(format, v...))
}

//记录error日志 20211208 gk
func Error(format string, v ...interface{}) {
	newPath := g.Log().GetPath() + "/error/"
	glog.Path(newPath).File("{Ymd}.log").Println(fmt.Sprintf(format, v...))
}

//检查错误 20211208 gk
func CheckErr(err error, extra string) bool {
	if err != nil {
		Error("%+v",gerror.Wrap(err, extra))
		return true
	}
	return false
}