package jst

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type supplierLogic struct {
}

var Supplier = supplierLogic{}

type SupplierQueryReq struct {
	PageNum      int    `json:"page_num"`                 //页数
	PageSize     int    `json:"page_size"`                //每页数量，最大100
	SupplierCoId string `json:"supplier_co_id,omitempty"` //供应商编号
	Status       int    `json:"status,omitempty"`         //合作状态-0:待授权；1:待审核；2:合作中;3:已拒绝；4:已终止
	CoName       string `json:"co_name,omitempty"`        //供应商名称
}

type SupplierQueryRes struct {
	CommonRes
	Data struct {
		Total       int `json:"total"`
		SupplierVos []struct {
			SupplierCoId string `json:"supplier_co_id"`
			CoName       string `json:"co_name"`
			Status       int    `json:"status"`
		} `json:"supplier_vos"`
	} `json:"data"`
}

func (s *supplierLogic) Query(ctx context.Context, req SupplierQueryReq) (res *SupplierQueryRes, err error) {
	var method = "open/api/company/inneropen/partner/channel/querymysupplier"
	body, err := newBody(ctx)
	if err != nil {
		return
	}
	body.Biz = gjson.New(req).MustToJsonString()
	result, err := post(ctx, method, body)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)

	return
}

type SupplierGoodsReq struct {
	SupplierCoId   string `json:"supplier_co_id"`
	PageNum        int    `json:"page_num"`
	PageSize       int    `json:"page_size"`
	SkuType        string `json:"sku_type,omitempty"`
	EndTime        string `json:"end_time,omitempty"`
	StockEnd       int    `json:"stock_end,omitempty"`
	ItemName       string `json:"item_name,omitempty"`
	BrandName      string `json:"brand_name,omitempty"`
	StyleCodes     string `json:"style_codes,omitempty"`
	ChildItemCodes string `json:"child_item_codes,omitempty"`
	AscOrDesc      bool   `json:"asc_or_desc,omitempty"`
	StartTime      string `json:"start_time,omitempty"`
	ItemCodes      string `json:"item_codes,omitempty"`
	StockStart     int    `json:"stock_start,omitempty"`
	SkuCode        string `json:"sku_code,omitempty"`
	OrderByKey     int    `json:"order_by_key,omitempty"`
}

type SupplierGoodsRes struct {
	CommonRes
	Data struct {
		Total   int  `json:"total"`
		HasNext bool `json:"has_next"`
		List    []struct {
			ItemCode        string  `json:"item_code"`
			Created         string  `json:"created"`
			Weight          float64 `json:"weight"`
			StyleCode       string  `json:"style_code"`
			BrandName       string  `json:"brand_name"`
			ItemName        string  `json:"item_name"`
			SupplyPrice     float64 `json:"supply_price"`
			Pic             string  `json:"pic"`
			SalePrice       float64 `json:"sale_price"`
			StockStr        string  `json:"stock_str"`
			PropertiesValue string  `json:"properties_value"`
			BasePrice       float64 `json:"base_price"`
			Stock           int     `json:"stock"`
		} `json:"list"`
	} `json:"data"`
}

func (s *supplierLogic) Goods(ctx context.Context, req SupplierGoodsReq) (res *SupplierGoodsRes, err error) {
	var method = "open/api/goods/inneropen/supplier/goods/querydiserpgoodsdata"
	body, err := newBody(ctx)
	if err != nil {
		return
	}
	body.Biz = gjson.New(req).MustToJsonString()
	result, err := post(ctx, method, body)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)

	return
}
