package jst

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type shopLogic struct {
}

var Shop = shopLogic{}

type ShopQueryReq struct {
	Index int   `json:"page_index"`         //第几页
	Size  int   `json:"page_size"`          //每页记录数
	ID    []int `json:"shop_ids,omitempty"` //店铺编码
}

type ShopQueryRes struct {
	CommonRes
}

func (s *shopLogic) Query(ctx context.Context, req ShopQueryReq) (res *ShopQueryRes, err error) {
	var method = "open/category/query"
	body, err := newBody(ctx)
	if err != nil {
		return
	}
	body.Biz = gjson.New(req).MustToJsonString()
	result, err := post(ctx, method, body)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)

	return
}
