package jst

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
)

type categoryLogic struct {
}

var Category = categoryLogic{}

type CategoryQueryReq struct {
	Index int      `json:"page_index"`               //第几页
	Size  int      `json:"page_size"`                //每页记录数
	Begin string   `json:"modified_begin,omitempty"` //修改开始时间 2020-01-1218:34:13
	End   string   `json:"modified_end,omitempty"`   //修改结束时间 2020-01-1218:34:13
	CId   []string `json:"c_ids,omitempty"`          //类目id集合
	PId   []string `json:"parent_c_ids,omitempty"`   //父级类目id集合
}

type CategoryQueryRes struct {
	CommonRes
	Data struct {
		Datas     interface{} `json:"datas"`
		RequestId interface{} `json:"requestId"`
		PageIndex int         `json:"page_index"`
		HasNext   bool        `json:"has_next"`
		DataCount int         `json:"data_count"`
		PageCount int         `json:"page_count"`
		PageSize  int         `json:"page_size"`
	} `json:"data"`
}

func (s *categoryLogic) Query(ctx context.Context, req CategoryQueryReq) (res *CategoryQueryRes, err error) {
	var method = "open/category/query"
	body, err := newBody(ctx)
	if err != nil {
		return
	}
	body.Biz = gjson.New(req).MustToJsonString()
	result, err := post(ctx, method, body)
	if err != nil {
		return
	}
	err = gjson.New(result).Scan(&res)

	return
}
