package jst

import (
	"context"
	"github.com/gogf/gf/container/garray"
	"github.com/gogf/gf/crypto/gmd5"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/os/gtime"
	"github.com/gogf/gf/text/gstr"
	"github.com/gogf/gf/util/gconv"
	"time"
)

type Config struct {
	AppKey    string
	AppSecret string
	ApiUrl    string
	Env       bool
}

type CommonReq struct {
	AppKey      string `json:"app_key"`
	AccessToken string `json:"access_token"`
	Timestamp   string `json:"timestamp"`
	Charset     string `json:"charset"`
	Version     string `json:"version"`
	Biz         string `json:"biz"`
}

type CommonRes struct {
	Msg       string `json:"msg"`
	Code      int    `json:"code"`
	RequestId string `json:"request_id"`
}

const (
	CacheKey = "jst:token"
	PkgName  = "jst"
	Test     = "https://dev-apijushuitan.com/"
	Pro      = "https://openapi.jushuitan.com/"
)

var server *Config

func New(req *Config) {
	if req.Env {
		req.ApiUrl = Test
	} else {
		req.ApiUrl = Pro
	}
	server = req
}

func post(ctx context.Context, method string, req interface{}) (res string, err error) {
	Start := gtime.TimestampMilli()
	Url := server.ApiUrl + method
	request := gjson.New(req)
	err = request.Set("version", 2)
	err = request.Set("sign", sign(request.Map()))
	if err != nil {
		return
	}

	Request := g.Client()
	Request.SetHeader("Content-Type", "application/x-www-form-urlencoded")
	resp, err := Request.Timeout(time.Second*5).Post(Url, request.Map())
	defer func() {
		_ = resp.Close()
		paramStr := request.MustToJsonString()
		ctx = context.WithValue(ctx, "Method", "POST")
		ctx = context.WithValue(ctx, "URI", Url)
		if err != nil {
			g.Log().Ctx(ctx).Cat(PkgName).Cat("error").Infof("参数【%v】错误【%v】响应时间【%v】", paramStr, err.Error(), gtime.TimestampMilli()-Start)
		} else {
			g.Log().Ctx(ctx).Cat(PkgName).Infof("参数【%v】响应【%v】响应时间【%v】", paramStr, res, gtime.TimestampMilli()-Start)
		}
	}()
	res = resp.ReadAllString()
	return
}

func sign(req interface{}) (res string) {
	param := gconv.MapStrStr(req)
	var keys = garray.NewStrArray()
	for key := range param {
		keys.Append(key)
	}
	for _, key := range keys.Sort().Slice() {
		if key == "sign" {
			continue
		}
		res += key
		res += param[key]
	}
	return gstr.ToLower(gmd5.MustEncryptString(server.AppSecret + res))
}

func newBody(ctx context.Context) (res *CommonReq, err error) {
	token, err := Token.Get(ctx)
	if err != nil {
		return
	}
	res = &CommonReq{
		AppKey:      server.AppKey,
		AccessToken: token,
		Timestamp:   gtime.TimestampStr(),
		Charset:     "utf-8",
		Version:     "2",
	}
	return
}
