package itao

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type goods struct {
}

var Goods = goods{}

type GoodsListReq struct {
	Q         string `json:"q,omitempty"`         //关键词
	SessionId string `json:"sessionId,omitempty"` //长度不要超过32位，用来分页去重，当前请求只是翻页，则这个值不要改变
	Sort      string `json:"sort,omitempty"`      //排序参数
	// 价格降序:sort=price:des
	//价格升序:sort=price:asc
	//综合排序:sort=popular:des
	//销量降序:sort=sales:des
	//客户响应率倒序 sort=cst_reply_rate:des
	//客户响应率正序 sort=cst_reply_rate:acs
	//好评率倒序 sort=pos_review_all_rate_30d:des
	//好评率正序 sort=pos_review_all_rate:acs
	//退货率倒序 sort=tj_pinzhi_rfd_rate:des
	//退货率正序 sort=tj_pinzhi_rfd_rate:acs
	//发货时效倒序 sort=ship_ord_rate_7d_104:des
	//发货时效正序 sort=ship_ord_rate_7d_104:acs
	Price string `json:"price,omitempty"` //价格筛选
	//89~248     从89元到248元
	//89~            大于89元
	//~248          小于248元
	Cate    string `json:"cate,omitempty"`    //一级类目筛选
	S       int    `json:"s"`                 //默认0，不是页码，是每次查询的起始位置，相当于 页码x每页数量
	N       int    `json:"n"`                 //默认20， 每页数量，建议值10，不宜过大
	Feature string `json:"feature,omitempty"` //字符串，不是json 请求示例 ：{\"poolId\":\"1001\"}
	//目前支持的key
	//精选商品池映射 poolId
	//退货率  refundRateBegin
	//退货率 refundRateEnd
	//好评率 posReviewRateBegin
	//好评率 posReviewRateEnd
	//客服响应率 cstRateBegin
	//客服响应率 cstRateEnd
	//发货时效 shipRateBegin
	//发货时效 shipRateEnd
}

type GoodsListRes struct {
	Result struct {
		Auctions []struct {
			Category               string `json:"category"`
			CstRate                string `json:"cstRate"`
			LevelOneCat            string `json:"levelOneCat"`
			Nid                    string `json:"nid"`
			PictUrl                string `json:"pictUrl"`
			PosReviewRate          string `json:"posReviewRate"`
			RefundRate             string `json:"refundRate"`
			ReservePrice           string `json:"reservePrice"`
			ShipIn24               string `json:"shipIn24"`
			ShipRate               string `json:"shipRate"`
			TejiaTotalSoldQuantity string `json:"tejiaTotalSoldQuantity"`
			Title                  string `json:"title"`
			ZkFinalPrice           string `json:"zkFinalPrice"`
		} `json:"auctions"`
		PageIndex  int `json:"pageIndex"`
		PageSize   int `json:"pageSize"`
		TotalCount int `json:"totalCount"`
	} `json:"result"`
}

func (goods) List(ctx context.Context, req GoodsListReq) (res *GoodsListRes, err error) {
	method := "tt.item.list.v2"

	result, err := server.Get(ctx, method, g.Map{
		"request": req,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDetailReq struct {
	AppKey int    `json:"appKey"`
	ItemId string `json:"itemId"`
	SkuId  string `json:"skuId,omitempty"`
}

type GoodsDetailRes struct {
	ErrorMessage string `json:"error_message"`
	ErrorCode    string `json:"error_code"`
	DebugInfoMap struct {
		TraceId string `json:"traceId"`
	} `json:"debugInfoMap"`
	EnterNewLink string `json:"enterNewLink"`
	Item         struct {
		CategoryId   []string `json:"categoryId"`   //商品的类目列表，从一级类目开始
		CategoryName []string `json:"categoryName"` //商品的类目标题
		City         string   `json:"city"`
		FastPostFee  int      `json:"fastPostFee"` //商品的快递费用
		Images       []string `json:"images"`
		ItemId       string   `json:"itemId"` //商品id
		ItemServices []struct {
			ActionTitle string `json:"actionTitle,omitempty"`
			ActionUrl   string `json:"actionUrl,omitempty"`
			Desc        string `json:"desc"`
			Title       string `json:"title"`
		} `json:"itemServices"`
		MainPic         string `json:"mainPic"`
		OrdinaryPostFee int    `json:"ordinaryPostFee"` //商品的平邮费用
		Props           []struct {
			Content string `json:"content"`
			Word    string `json:"word"`
		} `json:"props"`
		Prov         string `json:"prov"`
		Receipt      bool   `json:"receipt"`
		SoldQuantity int    `json:"soldQuantity"` //商品的销量
		Status       int    `json:"status"`       //商品的状态 0，1正常,-1:用户删除,-2:用户下架,-3 小二下架，-4 小二删除，-5 从未上架，-9 CC
		Title        string `json:"title"`        //商品的类目标题
	} `json:"item"`
	Seller struct { //商品的卖家信息
		ShopName string `json:"shopName"` //店铺名称
		SellerId string `json:"sellerId"`
	} `json:"seller"`
	SkuBase struct {
		Props []struct {
			Name   string `json:"name"` //sku的属性名称
			Pid    string `json:"pid"`  //sku的属性id
			Values []struct {
				Image string `json:"image"`
				Name  string `json:"name"` //sku的属性内容
				Vid   string `json:"vid"`  //sku的属性内容id
			} `json:"values"`
		} `json:"props"`
		Skus []struct {
			PropPath string `json:"propPath"` //sku的属性路径
			SkuId    string `json:"skuId"`
		} `json:"skus"`
	} `json:"skuBase"`
	SkuCore struct {
		Sku2Info map[string]GoodsItem `json:"sku2info"`
	} `json:"skuCore"`
}

type GoodsItem struct {
	QuantityVague  string `json:"quantityVague"` //模糊化库存，实际库存大于200时展示200，小于200时展示实际的值
	OriginalPrice  string `json:"originalPrice"` //特价，报名特价版的价格	单位：分
	FinalPrice     string `json:"finalPrice"`
	TjbMarketPrice string `json:"tjbMarketPrice"` //市场价
	PriceMoney     string `json:"priceMoney"`     //单品优惠价，参与活动后得价格
}

//Detail 详情
func (goods) Detail(ctx context.Context, GoodsID string) (res *GoodsDetailRes, err error) {
	method := "tt.item.detail.v2"
	var request = GoodsDetailReq{
		AppKey: gconv.Int(server.AppKey),
		ItemId: GoodsID,
		SkuId:  "",
	}

	result, err := server.Post(ctx, method, g.Map{
		"parameters": request,
	})
	_ = gjson.New(result).Scan(&res)
	return
}

type GoodsDescRes struct {
	ErrorMessage string         `json:"error_message"`
	ErrorCode    string         `json:"error_code"`
	Components   *GoodsDescItem `json:"components"`
}

type GoodsDescJson struct {
	ErrorMessage string `json:"error_message"`
	ErrorCode    string `json:"error_code"`
	Components   string `json:"components"`
}
type GoodsDescItem struct {
	ComponentData struct {
		DetailPic1 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_1"`
		DetailPic10 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_10"`
		DetailPic11 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_11"`
		DetailPic12 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_12"`
		DetailPic2 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_2"`
		DetailPic3 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_3"`
		DetailPic4 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_4"`
		DetailPic5 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_5"`
		DetailPic6 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_6"`
		DetailPic7 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_7"`
		DetailPic8 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_8"`
		DetailPic9 struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_9"`
		DetailPicTmallPriceDesc struct {
			Actions  []string      `json:"actions"`
			Children []interface{} `json:"children"`
			Model    struct {
				LocateId string `json:"locateId"`
				PicUrl   string `json:"picUrl"`
			} `json:"model"`
			Styles struct {
				Size struct {
					Height string `json:"height"`
					Width  string `json:"width"`
				} `json:"size"`
			} `json:"styles"`
		} `json:"detail_pic_tmallPriceDesc"`
	} `json:"componentData"`
	Layout []struct {
		ID  string `json:"ID"`
		Key string `json:"key"`
	} `json:"layout"`
}

//Desc 详情描述
func (goods) Desc(ctx context.Context, GoodsID string) (res *GoodsDescRes, err error) {
	method := "tt.item.desc"

	result, err := server.Get(ctx, method, g.Map{
		"itemId": GoodsID,
	})
	var data *GoodsDescJson
	err = gjson.New(result).Scan(&data)
	if err != nil {
		return
	}
	if data.ErrorCode != "" {
		err = gjson.New(result).Scan(&res)
		return
	}
	res = new(GoodsDescRes)
	_ = gjson.New(data.Components).Scan(&res.Components)
	return
}

type GoodsCategoryRes struct {
	ErrorMessage  string   `json:"error_message"`
	ErrorCode     string   `json:"error_code"`
	CateNameLists []string `json:"cateNameLists"`
	Code          string   `json:"code"`
	ItemId        string   `json:"itemId"`
	ItemName      string   `json:"itemName"`
	Message       string   `json:"message"`
}

//Category 商品类目
func (goods) Category(ctx context.Context, GoodsID string) (res *GoodsCategoryRes, err error) {
	method := "tt.item.cateInfo"

	result, err := server.Get(ctx, method, g.Map{
		"itemId": GoodsID,
	})
	_ = gjson.New(result).Scan(&res)
	return
}
