package aliNew

import (
	"context"
	"github.com/gogf/gf/encoding/gjson"
	"github.com/gogf/gf/frame/g"
	"github.com/gogf/gf/util/gconv"
)

type goodsAli struct {
}

var Goods = goodsAli{}

type GoodsListReq struct {
	RuleId      string `json:"ruleId,omitempty"`         //选品规划id
	CategoryId  string `json:"categoryId,omitempty"` //分类ID
	KeyWords    string `json:"keyWords,omitempty"`       //搜索关键词
	PageNo      int    `json:"pageNo"`                   //页码
	PageSize    int    `json:"pageSize"`                 //页面数量;最大20
	TopOfferIds string `json:"topOfferIds,omitempty"`    //商品置顶，只会在第一页置顶，和分页大小相同最多50个
	AccessToken string `json:"access_token"`
}

type GoodsListRes struct {
	Result struct {
		CommonRes
		Result struct {
			PageIndex    int `json:"pageIndex"`
			TotalRecords int `json:"totalRecords"`
			SizePerPage  int `json:"sizePerPage"`
			ResultList   []struct {
				ItemId      int64  `json:"itemId"`
				ImgUrl      string `json:"imgUrl"`
				Title       string `json:"title"`
				SalesCnt90D int    `json:"salesCnt90d"`
				MaxPrice    int    `json:"maxPrice,omitempty"`
				MinPrice    int    `json:"minPrice,omitempty"`
				ServiceList []struct {
					Code string `json:"code"`
					Name string `json:"name"`
				} `json:"serviceList"`
			} `json:"resultList"`
		} `json:"result"`
	} `json:"result"`
}

type GoodsInfoRes struct {
	CommonRes
	BizGroupInfos []struct {
		Support     bool   `json:"support"`
		Description string `json:"description"`
		Code        string `json:"code"`
	} `json:"bizGroupInfos"`
	ProductInfo struct {
		ProductID       int64           `json:"productID"`
		SupplierLoginId string          `json:"supplierLoginId"`
		MainVedio       string          `json:"mainVedio"`
		CategoryID      int             `json:"categoryID"`
		Subject         string          `json:"subject"`
		Description     string          `json:"description"`
		PictureAuth     bool            `json:"pictureAuth"`
		IntelligentInfo IntelligentInfo `json:"intelligentInfo"` //商品算法智能改写信息，包含算法优化后的商品标题和图片信息，未改写的则直接返回原标题和原图片
		Image           struct {
			Images []string `json:"images"`
		} `json:"productImage"`
		SkuInfos []struct {
			Attributes []struct {
				AttributeID    int    `json:"attributeID"`
				AttributeValue string `json:"attributeValue"`
				SkuImageURL    string `json:"skuImageUrl"`
				AttributeName  string `json:"attributeName"`
			} `json:"attributes"`
			CargoNumber  string  `json:"cargoNumber"`
			AmountOnSale int     `json:"amountOnSale"`
			Price        float64 `json:"price"`
			SkuID        int64   `json:"skuId"`
			SpecID       string  `json:"specId"`
			ConsignPrice float64 `json:"consignPrice"`
			Retailprice  float64 `json:"retailprice"`
			ChannelPrice float64 `json:"channelPrice"`
		} `json:"productSkuInfos"`
		SaleInfo struct {
			SupportOnlineTrade bool `json:"supportOnlineTrade"`
			MixWholeSale       bool `json:"mixWholeSale"`
			PriceAuth          bool `json:"priceAuth"`
			PriceRanges        []struct {
				StartQuantity int     `json:"startQuantity"`
				Price         float64 `json:"price"`
			} `json:"priceRanges"`
			AmountOnSale     float64 `json:"amountOnSale"`
			Unit             string  `json:"unit"`
			MinOrderQuantity int     `json:"minOrderQuantity"`
			QuoteType        int     `json:"quoteType"`
			Retailprice      float64 `json:"retailprice"`
			ConsignPrice     float64 `json:"consignPrice"`
			ChannelPrice     float64 `json:"channelPrice"`
		} `json:"productSaleInfo"`
		ShippingInfo struct {
			FreightTemplateID    int     `json:"freightTemplateID"`
			UnitWeight           float64 `json:"unitWeight"`
			SendGoodsAddressID   int     `json:"sendGoodsAddressId"`
			SendGoodsAddressText string  `json:"sendGoodsAddressText"`
			FreightTemplate      []struct {
				AddressCodeText    string `json:"addressCodeText"`
				FromAreaCode       string `json:"fromAreaCode"`
				ID                 int    `json:"id"`
				ExpressSubTemplate struct {
					SubTemplateDTO struct {
						ChargeType    int  `json:"chargeType"`
						IsSysTemplate bool `json:"isSysTemplate"`
						ServiceType   int  `json:"serviceType"`
						Type          int  `json:"type"`
					} `json:"subTemplateDTO"`
					RateList []struct {
						IsSysRate      bool   `json:"isSysRate"`
						ToAreaCodeText string `json:"toAreaCodeText"`
						RateDTO        struct {
							FirstUnit    int `json:"firstUnit"`
							FirstUnitFee int `json:"firstUnitFee"`
							NextUnit     int `json:"nextUnit"`
							NextUnitFee  int `json:"nextUnitFee"`
						} `json:"rateDTO"`
					} `json:"rateList"`
				} `json:"expressSubTemplate"`
				LogisticsSubTemplate struct {
					SubTemplateDTO struct {
						ChargeType    int  `json:"chargeType"`
						IsSysTemplate bool `json:"isSysTemplate"`
						ServiceType   int  `json:"serviceType"`
						Type          int  `json:"type"`
					} `json:"subTemplateDTO"`
				} `json:"logisticsSubTemplate"`
			} `json:"freightTemplate"`
			ChannelPriceFreePostage      bool `json:"channelPriceFreePostage"`
			ChannelPriceExcludeAreaCodes []struct {
				Code string `json:"code"`
				Name string `json:"name"`
			} `json:"channelPriceExcludeAreaCodes"`
		} `json:"shippingInfo"`
		QualityLevel    int    `json:"qualityLevel"`
		CategoryName    string `json:"categoryName"`
		ReferencePrice  string `json:"referencePrice"`
		Attributes      []struct {
			AttributeID   int    `json:"attributeID"`
			AttributeName string `json:"attributeName"`
			Value         string `json:"value"`
			IsCustom      bool   `json:"isCustom"`
		} `json:"productAttribute"`
		Status string `json:"status"`
	} `json:"productInfo"`
}

type IntelligentInfo struct {
	Title     string   `json:"title"`  //算法优化后的商品标题
	Images    []string `json:"images"` //主图列表，使用相对路径，需要增加域名：https://cbu01.alicdn.com/
	SkuImages []struct { //算法优化后的规格图片
		SkuId    int64  `json:"skuId"`    //规格ID
		ImageUrl string `json:"imageUrl"` //图片
	} `json:"skuImages"`
	DescriptionImages []string `json:"descriptionImages"` //算法优化后的详情图片
}

type GoodsFollowRes struct {
	Success      bool        `json:"success"`
	Data         interface{} `json:"data"`
	ErrorCode    int         `json:"errorCode"`
	ErrorMessage int         `json:"errorMessage"`
}

type RelationRes struct {
	Success      bool        `json:"success"`
	Data         interface{} `json:"data"`
	ErrorCode    int         `json:"errorCode"`
	ErrorMessage int         `json:"errorMessage"`
}

type OutshopAddRes struct {
	Code    int `json:"code"`
	Message int `json:"message"`
}


type RelationInfoReq struct {
	Channel     string `json:"channel"`     // 下游渠道代码
	OutShopCode string `json:"outShopCode"` //  下游店铺code
	OfferId     string `json:"offerId"`     //上游1688商品id
	OutItemCode  string `json:"outItemCode"` //下游外部商品码
	AccessToken  string `json:"access_token"`
}

type GoodsCategoryReq struct {
	CategoryID  int64  `json:"categoryID"`
	AccessToken string `json:"access_token"`
}

type GoodsCategoryRes struct {
	Succes       string `json:"succes"`
	CategoryInfo []struct {
		CategoryID       int    `json:"categoryID"`
		Name             string `json:"name"`
		IsLeaf           bool   `json:"isLeaf"`
		ParentIDs        []int  `json:"parentIDs"`
		MinOrderQuantity int    `json:"minOrderQuantity"`
		FeatureInfos     []struct {
			Key       string `json:"key"`
			Value     string `json:"value"`
			Status    int    `json:"status"`
			Hierarchy bool   `json:"hierarchy"`
		} `json:"featureInfos"`
		CategoryType        string `json:"categoryType"`
		IsSupportProcessing bool   `json:"isSupportProcessing"`
	} `json:"categoryInfo"`
}

//List 查询商品列表
func (goodsAli) List(ctx context.Context, req *GoodsListReq) (res *GoodsListRes, err error) {
	method := "com.alibaba.fenxiao/alibaba.pifatuan.product.list"

	req.AccessToken = server.AccessToken
	result, err := server.Post(ctx, method, gconv.Map(req))
	_ = gjson.New(result).Scan(&res)
	return
}

func (goodsAli) Info(ctx context.Context, req interface{}) (res *GoodsInfoRes, err error) {
	method := "com.alibaba.fenxiao/alibaba.fenxiao.productInfo.get"
	request := g.Map{
		"offerId":             gconv.Int64(req),
		"needCpsSuggestPrice": true,
		"needIntelligentInfo": true,
		"access_token":        server.AccessToken,
	}

	result, err := server.Post(ctx, method, request)
	_ = gjson.New(result).Scan(&res)
	return
}

//Follow 关注商品
func (goodsAli) Follow(ctx context.Context, GoodsID string) (res *GoodsFollowRes, err error) {
	method := "com.alibaba.product/alibaba.product.follow"

	result,err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"productId":    GoodsID,
	})
	_ = gjson.New(result).Scan(&res)

	return
}

//UnFollow 	解除关注商品
func (goodsAli) UnFollow(ctx context.Context, GoodsID string) (res *GoodsFollowRes, err error) {
	method := "com.alibaba.product/alibaba.product.unfollow.crossborder"

	result, err := server.Post(ctx, method, g.Map{
		"access_token": server.AccessToken,
		"productId":    GoodsID,
	})

	_ = gjson.New(result).Scan(&res)

	return
}

func (goodsAli) Category(ctx context.Context, CategoryID interface{}) (res *GoodsCategoryRes, err error) {
	method := "com.alibaba.product/alibaba.category.get"
	var req = &GoodsCategoryReq{
		CategoryID:  gconv.Int64(CategoryID),
		AccessToken: server.AccessToken,
	}
	result, err := server.Post(ctx, method, gconv.Map(req))
	_ = gjson.New(result).Scan(&res)

	return
}
